/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class VerticalStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (SideSkipPredicate.CTM.test(world, pos, state, adjState, side)) {
            return true;
        }
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        StairsType type = (StairsType)((Object)state.func_177229_b(PropertyHolder.STAIRS_TYPE));
        if (adjState.func_177230_c() == FBContent.blockFramedVerticalStairs.get()) {
            return this.testAgainstVerticalStairs(world, pos, dir, type, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedStairs.get()) {
            return this.testAgainstStairs(world, pos, dir, type, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedPanel.get()) {
            return this.testAgainstPanel(world, pos, dir, type, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedDoublePanel.get()) {
            return this.testAgainstDoublePanel(world, pos, dir, type, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedSlabCorner.get()) {
            return this.testAgainstCorner(world, pos, dir, type, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedCornerPillar.get()) {
            return this.testAgainstPillar(world, pos, dir, type, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedSlabEdge.get() && type != StairsType.VERTICAL && side.func_176740_k() != Direction.Axis.Y) {
            return this.testAgainstEdge(world, pos, dir, type, adjState, side);
        }
        if (adjState.func_203425_a((Block)FBContent.blockFramedHalfStairs.get())) {
            return VerticalStairsSkipPredicate.testAgainstHalfStairs(world, pos, dir, type, adjState, side);
        }
        return false;
    }

    private boolean testAgainstVerticalStairs(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        StairsType adjType = (StairsType)((Object)adjState.func_177229_b(PropertyHolder.STAIRS_TYPE));
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (!type.isBottom() && !adjType.isTop() && side == Direction.DOWN || !type.isTop() && !adjType.isBottom() && side == Direction.UP) {
            return dir == adjDir && SideSkipPredicate.compareState(world, pos, side);
        }
        if (side == dir && adjDir == dir.func_176735_f() || side == dir.func_176735_f() && adjDir == dir.func_176746_e()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstStairs(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        boolean adjBottom;
        Direction adjDir = (Direction)adjState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        boolean bl = adjBottom = adjState.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.BOTTOM;
        if (type == StairsType.VERTICAL && (side == Direction.UP && !adjBottom || side == Direction.DOWN && adjBottom)) {
            StairsShape adjShape = (StairsShape)adjState.func_177229_b((Property)BlockStateProperties.field_208146_au);
            if (adjDir == dir && adjShape == StairsShape.INNER_LEFT || adjDir == dir.func_176735_f() && adjShape == StairsShape.INNER_RIGHT) {
                return SideSkipPredicate.compareState(world, pos, side);
            }
        } else if (type.isTop() == adjBottom && (side == dir && adjDir == dir.func_176735_f() || side == dir.func_176735_f() && adjDir == dir)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstPanel(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type != StairsType.VERTICAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (side == dir.func_176746_e() && adjDir == dir || side == dir.func_176734_d() && adjDir == dir.func_176735_f()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstDoublePanel(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type != StairsType.VERTICAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_NE);
        if (side == dir.func_176746_e() && (adjDir == dir || adjDir == dir.func_176734_d())) {
            return SideSkipPredicate.compareState(world, pos, side, dir);
        }
        if (side == dir.func_176734_d() && (adjDir == dir.func_176735_f() || adjDir == dir.func_176746_e())) {
            return SideSkipPredicate.compareState(world, pos, side, dir.func_176735_f());
        }
        return false;
    }

    private boolean testAgainstCorner(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type == StairsType.VERTICAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if ((side.func_176740_k() == Direction.Axis.Y || side == dir.func_176734_d() || side == dir.func_176746_e()) && type.isTop() != adjTop && dir == adjDir) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstPillar(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (type == StairsType.VERTICAL ? (side == dir.func_176746_e() || side == dir.func_176734_d()) && adjDir == dir : side.func_176740_k() == Direction.Axis.Y && side == Direction.UP == type.isTop() && adjDir == dir) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstEdge(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (side == dir.func_176746_e() && adjDir == dir || side == dir.func_176734_d() && adjDir == dir.func_176735_f()) {
            return adjTop != type.isTop() && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        boolean adjRight = (Boolean)adjState.func_177229_b((Property)PropertyHolder.RIGHT);
        if (adjTop == type.isTop()) {
            return false;
        }
        if (adjRight && adjDir == dir && side == dir.func_176735_f() || !adjRight && adjDir == dir.func_176735_f() && side == dir) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }
}

