/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class SlabSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (side.func_176740_k() == Direction.Axis.Y) {
            return SideSkipPredicate.CTM.test(world, pos, state, adjState, side);
        }
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        if (adjState.func_177230_c() == FBContent.blockFramedSlab.get()) {
            return this.testAgainstSlab(world, pos, top, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedDoubleSlab.get()) {
            return this.testAgainstDoubleSlab(world, pos, top, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedSlabEdge.get()) {
            return this.testAgainstEdge(world, pos, top, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedStairs.get()) {
            return this.testAgainstStairs(world, pos, top, adjState, side);
        }
        return false;
    }

    private boolean testAgainstSlab(IBlockReader world, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        if (top != (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP)) {
            return false;
        }
        return SideSkipPredicate.compareState(world, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private boolean testAgainstDoubleSlab(IBlockReader world, BlockPos pos, boolean top, Direction side) {
        Direction face = top ? Direction.UP : Direction.DOWN;
        return SideSkipPredicate.compareState(world, pos, side, face);
    }

    private boolean testAgainstEdge(IBlockReader world, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        if (top != (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP)) {
            return false;
        }
        if (adjState.func_177229_b((Property)PropertyHolder.FACING_HOR) != side.func_176734_d()) {
            return false;
        }
        return SideSkipPredicate.compareState(world, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private boolean testAgainstStairs(IBlockReader world, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        StairsShape adjShape = (StairsShape)adjState.func_177229_b((Property)BlockStateProperties.field_208146_au);
        boolean bl = adjTop = adjState.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.TOP;
        if (top == adjTop && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.func_176734_d())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }
}

