/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.util.SideSkipPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class InnerThreewayCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (SideSkipPredicate.CTM.test(world, pos, state, adjState, side)) {
            return true;
        }
        if (!(adjState.func_177230_c() instanceof IFramedBlock)) {
            return false;
        }
        BlockType adjBlock = ((IFramedBlock)adjState.func_177230_c()).getBlockType();
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        if (((IFramedBlock)state.func_177230_c()).getBlockType() == BlockType.FRAMED_INNER_THREEWAY_CORNER) {
            dir = dir.func_176746_e();
        }
        if (adjBlock == BlockType.FRAMED_INNER_PRISM_CORNER || adjBlock == BlockType.FRAMED_INNER_THREEWAY_CORNER) {
            return this.testAgainstInnerThreewayCorner(world, pos, dir, top, adjBlock, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_PRISM_CORNER || adjBlock == BlockType.FRAMED_THREEWAY_CORNER) {
            return this.testAgainstThreewayCorner(world, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_PRISM_CORNER || adjBlock == BlockType.FRAMED_DOUBLE_THREEWAY_CORNER) {
            return this.testAgainstDoubleThreewayCorner(world, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_SLOPE || adjBlock == BlockType.FRAMED_RAIL_SLOPE) {
            return this.testAgainstSlope(world, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_SLOPE) {
            return this.testAgainstDoubleSlope(world, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_CORNER_SLOPE) {
            return this.testAgainstCorner(world, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_INNER_CORNER_SLOPE) {
            return this.testAgainstInnerCorner(world, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_CORNER) {
            return this.testAgainstDoubleCorner(world, pos, dir, top, adjState, side);
        }
        return false;
    }

    private boolean testAgainstInnerThreewayCorner(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockType adjBlock, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (adjBlock == BlockType.FRAMED_INNER_THREEWAY_CORNER) {
            adjDir = adjDir.func_176746_e();
        }
        if (adjTop == top && (side == dir.func_176746_e() && adjDir == dir.func_176746_e() || side == dir.func_176734_d() && adjDir == dir.func_176735_f())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (adjTop != top && adjDir == dir && (side == Direction.UP && !top || side == Direction.DOWN && top)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstThreewayCorner(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (adjTop == top && adjDir == dir && (side == dir.func_176746_e() || side == dir.func_176734_d() || side == Direction.UP && !top || side == Direction.DOWN && top)) {
            return SideSkipPredicate.compareState(world, pos, side, adjDir);
        }
        return false;
    }

    private boolean testAgainstDoubleThreewayCorner(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (adjTop == top && (side == dir.func_176734_d() && adjDir == dir.func_176735_f() || side == dir.func_176746_e() && adjDir == dir.func_176746_e())) {
            return SideSkipPredicate.compareState(world, pos, side, top ? Direction.UP : Direction.DOWN);
        }
        if (adjTop != top && adjDir == dir && (side == Direction.UP && !top || side == Direction.DOWN && top)) {
            return SideSkipPredicate.compareState(world, pos, side, top ? Direction.DOWN : Direction.UP);
        }
        if (adjTop != top && adjDir == dir.func_176734_d() && (side == dir.func_176734_d() || side == dir.func_176746_e() || side == Direction.UP && !top || side == Direction.DOWN && top)) {
            return SideSkipPredicate.compareState(world, pos, side, top ? Direction.UP : Direction.DOWN);
        }
        return false;
    }

    private boolean testAgainstSlope(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = Utils.getBlockFacing(adjState);
        SlopeType adjType = Utils.getSlopeType(adjState);
        if (adjType != SlopeType.HORIZONTAL && (side == dir.func_176746_e() && adjDir == dir || side == dir.func_176734_d() && adjDir == dir.func_176735_f())) {
            return adjType == SlopeType.TOP == top && SideSkipPredicate.compareState(world, pos, side);
        }
        if (adjType == SlopeType.HORIZONTAL && adjDir == dir && (side == Direction.UP && !top || side == Direction.DOWN && top)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstDoubleSlope(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.func_177229_b(PropertyHolder.SLOPE_TYPE));
        if (adjType != SlopeType.HORIZONTAL) {
            if (adjDir == dir && adjType == SlopeType.TOP == top || adjDir == dir.func_176734_d() && adjType == SlopeType.TOP != top) {
                return side == dir.func_176746_e() && SideSkipPredicate.compareState(world, pos, side, dir);
            }
            if (adjDir == dir.func_176735_f() && adjType == SlopeType.TOP == top || adjDir == dir.func_176746_e() && adjType == SlopeType.TOP != top) {
                return side == dir.func_176734_d() && SideSkipPredicate.compareState(world, pos, side, dir.func_176735_f());
            }
        } else if (adjDir == dir || adjDir == dir.func_176734_d()) {
            return (side == Direction.UP && !top || side == Direction.DOWN && top) && SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstCorner(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (!(adjType.isHorizontal() || adjType.isTop() != top || adjDir != dir || side != dir.func_176746_e() && side != dir.func_176734_d())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (adjType.isHorizontal() && (side == Direction.UP && !top || side == Direction.DOWN && top) && (adjDir == dir && !adjType.isRight() || adjDir == dir.func_176735_f() && adjType.isRight())) {
            return adjType.isTop() == top && SideSkipPredicate.compareState(world, pos, side);
        }
        if (adjType.isHorizontal() && (side == dir.func_176746_e() && adjDir == dir && !adjType.isRight() || side == dir.func_176734_d() && adjDir == dir.func_176735_f() && adjType.isRight())) {
            return adjType.isTop() == top && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstInnerCorner(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (!adjType.isHorizontal() && adjType.isTop() == top && (side == dir.func_176746_e() && adjDir == dir || side == dir.func_176734_d() && adjDir == dir.func_176734_d())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (adjType.isHorizontal() && adjType.isTop() != top && (side == Direction.UP && !top || side == Direction.DOWN && top) && (adjDir == dir && !adjType.isRight() || adjDir == dir.func_176735_f() && adjType.isRight())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (adjType.isHorizontal() && adjType.isTop() == top && (side == dir.func_176746_e() && adjDir == dir && adjType.isRight() || side == dir.func_176734_d() && adjDir == dir.func_176735_f() && !adjType.isRight())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstDoubleCorner(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (!adjType.isHorizontal()) {
            if (adjType.isTop() == top && (side == dir.func_176734_d() && adjDir == dir.func_176735_f() || side == dir.func_176746_e() && adjDir == dir.func_176746_e())) {
                return SideSkipPredicate.compareState(world, pos, side, top ? Direction.UP : Direction.DOWN);
            }
            if (adjType.isTop() != top && (side == dir.func_176734_d() && adjDir == dir.func_176734_d() || side == dir.func_176746_e() && adjDir == dir.func_176734_d())) {
                return SideSkipPredicate.compareState(world, pos, side, top ? Direction.UP : Direction.DOWN);
            }
        } else if (adjType.isTop() != top && (side == Direction.UP && !top || side == Direction.DOWN && top)) {
            if (adjDir == dir && !adjType.isRight() || adjDir == dir.func_176735_f() && adjType.isRight()) {
                return SideSkipPredicate.compareState(world, pos, side, adjDir);
            }
            if (adjDir == dir.func_176734_d() && !adjType.isRight() || adjDir == dir.func_176746_e() && adjType.isRight()) {
                return SideSkipPredicate.compareState(world, pos, side, adjDir.func_176734_d());
            }
        } else {
            if (adjType.isTop() == top && (side == dir.func_176734_d() && !adjType.isRight() && adjDir == dir.func_176735_f() || side == dir.func_176746_e() && adjType.isRight() && adjDir == dir)) {
                return SideSkipPredicate.compareState(world, pos, side, adjDir);
            }
            if (adjType.isTop() != top && (side == dir.func_176746_e() && !adjType.isRight() && adjDir == dir.func_176734_d() || side == dir.func_176734_d() && adjType.isRight() && adjDir == dir.func_176746_e())) {
                return SideSkipPredicate.compareState(world, pos, side, adjDir.func_176734_d());
            }
        }
        return false;
    }
}

