/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class HalfStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction baseFace;
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        boolean right = (Boolean)state.func_177229_b((Property)PropertyHolder.RIGHT);
        Direction stairFace = right ? dir.func_176746_e() : dir.func_176735_f();
        Direction direction = baseFace = top ? Direction.UP : Direction.DOWN;
        if (adjState.func_203425_a((Block)FBContent.blockFramedHalfStairs.get())) {
            return HalfStairsSkipPredicate.testAgainstHalfStairs(world, pos, dir, top, right, stairFace, adjState, side);
        }
        if (side == stairFace) {
            if (adjState.func_203425_a((Block)FBContent.blockFramedStairs.get())) {
                return HalfStairsSkipPredicate.testAgainstStairs(world, pos, top, adjState, side);
            }
            if (adjState.func_203425_a((Block)FBContent.blockFramedVerticalStairs.get())) {
                return HalfStairsSkipPredicate.testAgainstVerticalStairs(world, pos, dir, top, right, adjState, side);
            }
        } else {
            if (adjState.func_203425_a((Block)FBContent.blockFramedSlabEdge.get())) {
                return HalfStairsSkipPredicate.testAgainstSlabEdge(world, pos, dir, top, right, baseFace, adjState, side);
            }
            if (adjState.func_203425_a((Block)FBContent.blockFramedCornerPillar.get())) {
                return HalfStairsSkipPredicate.testAgainstCornerPillar(world, pos, dir, right, baseFace, adjState, side);
            }
            if (adjState.func_203425_a((Block)FBContent.blockFramedSlabCorner.get())) {
                return HalfStairsSkipPredicate.testAgainstSlabCorner(world, pos, dir, top, right, baseFace, adjState, side);
            }
            if (adjState.func_203425_a((Block)FBContent.blockFramedPanel.get())) {
                return HalfStairsSkipPredicate.testAgainstPanel(world, pos, dir, right, baseFace, adjState, side);
            }
            if (adjState.func_203425_a((Block)FBContent.blockFramedDoublePanel.get())) {
                return HalfStairsSkipPredicate.testAgainstDoublePanel(world, pos, dir, stairFace, baseFace, adjState, side);
            }
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, boolean right, Direction stairFace, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        boolean adjRight = (Boolean)adjState.func_177229_b((Property)PropertyHolder.RIGHT);
        if (side == stairFace) {
            return adjDir == dir && adjTop == top && adjRight != right && SideSkipPredicate.compareState(world, pos, side);
        }
        if (side.func_176740_k() == Direction.Axis.Y) {
            return adjDir == dir && adjTop != top && adjRight == right && SideSkipPredicate.compareState(world, pos, side);
        }
        if (side == dir) {
            return adjDir == dir.func_176734_d() && adjRight != right && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstStairs(IBlockReader world, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)StairsBlock.field_176309_a);
        StairsShape adjShape = (StairsShape)adjState.func_177229_b((Property)StairsBlock.field_176310_M);
        boolean adjTop = adjState.func_177229_b((Property)StairsBlock.field_176308_b) == Half.TOP;
        return top == adjTop && StairsSkipPredicate.isStairSide(adjShape, adjDir, side.func_176734_d()) && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstVerticalStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.func_177229_b(PropertyHolder.STAIRS_TYPE));
        if (right && adjDir == dir || !right && adjDir == dir.func_176746_e()) {
            return adjType.isTop() != top && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlabEdge(IBlockReader world, BlockPos pos, Direction dir, boolean top, boolean right, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace && side != dir.func_176734_d()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (right && adjDir == dir.func_176746_e() || !right && adjDir == dir.func_176735_f()) {
            return adjTop == top == (side == dir.func_176734_d()) && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstCornerPillar(IBlockReader world, BlockPos pos, Direction dir, boolean right, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace.func_176734_d() && side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (side == dir && (right && adjDir == dir.func_176734_d() || !right && adjDir == dir.func_176735_f())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (side == baseFace.func_176734_d() && (right && adjDir == dir.func_176746_e() || !right && adjDir == dir)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlabCorner(IBlockReader world, BlockPos pos, Direction dir, boolean top, boolean right, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace.func_176734_d() && side != dir.func_176734_d()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (right && adjDir == dir.func_176746_e() || !right && adjDir == dir) {
            return adjTop == top && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPanel(IBlockReader world, BlockPos pos, Direction dir, boolean right, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace && side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (right && adjDir == dir.func_176746_e() || !right && adjDir == dir.func_176735_f()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(IBlockReader world, BlockPos pos, Direction dir, Direction stairFace, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace && side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_NE);
        return adjDir.func_176740_k() != dir.func_176740_k() && SideSkipPredicate.compareState(world, pos, side, stairFace);
    }
}

