/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import team.chisel.ctm.api.IFacade;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.client.util.ClientConfig;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.item.FramedBlueprintItem;
import xfacthd.framedblocks.common.tileentity.FramedDoubleTileEntity;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;
import xfacthd.framedblocks.common.util.CommonConfig;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.ServerConfig;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public interface IFramedBlock
extends IFacade {
    public BlockType getBlockType();

    public static AbstractBlock.Properties createProperties() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_226896_b_().harvestTool(ToolType.AXE).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a).func_235847_c_(IFramedBlock::isBlockSuffocating).func_235842_b_(IFramedBlock::isBlockSuffocating);
    }

    public static boolean isBlockSuffocating(BlockState state, IBlockReader level, BlockPos pos) {
        return ((IFramedBlock)state.func_177230_c()).isSuffocating(state, level, pos);
    }

    default public BlockItem createItemBlock() {
        Block block = (Block)this;
        BlockItem item = new BlockItem(block, new Item.Properties().func_200916_a(FramedBlocks.FRAMED_GROUP));
        item.setRegistryName(block.getRegistryName());
        return item;
    }

    default public void tryApplyCamoImmediately(World world, BlockPos pos, @Nullable LivingEntity placer, ItemStack stack) {
        if (!world.func_201670_d() && placer instanceof PlayerEntity) {
            TileEntity te;
            PlayerEntity player = (PlayerEntity)placer;
            if (player.func_184614_ca() != stack) {
                return;
            }
            ItemStack otherStack = player.func_184592_cb();
            if (otherStack.func_77973_b() instanceof BlockItem && !(((BlockItem)otherStack.func_77973_b()).func_179223_d() instanceof IFramedBlock) && (te = world.func_175625_s(pos)) instanceof FramedTileEntity && !(te instanceof FramedDoubleTileEntity)) {
                Vector3d hitVec = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                ((FramedTileEntity)te).handleInteraction(player, Hand.OFF_HAND, new BlockRayTraceResult(hitVec, Direction.UP, pos, false));
            }
        }
    }

    default public ActionResultType handleBlockActivated(World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedTileEntity) {
            return ((FramedTileEntity)te).handleInteraction(player, hand, hit);
        }
        return ActionResultType.FAIL;
    }

    default public int getLight(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedTileEntity) {
            return ((FramedTileEntity)te).getLightValue();
        }
        return 0;
    }

    default public SoundType getSound(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState camoState;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedTileEntity && !(camoState = ((FramedTileEntity)te).getCamoState()).func_196958_f()) {
            return camoState.func_215695_r();
        }
        return ((Block)this).func_220072_p(state);
    }

    default public List<ItemStack> getDrops(List<ItemStack> drops, LootContext.Builder builder) {
        TileEntity te = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (te instanceof FramedTileEntity) {
            ((FramedTileEntity)te).addCamoDrops(drops);
        }
        return drops;
    }

    default public CtmPredicate getCtmPredicate() {
        return this.getBlockType().getCtmPredicate();
    }

    @Override
    @Nonnull
    @Deprecated
    default public BlockState getFacade(@Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nullable Direction side) {
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    @Nonnull
    default public BlockState getFacade(@Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nullable Direction side, @Nonnull BlockPos connection) {
        TileEntity te;
        BlockState state = world.func_180495_p(pos);
        if (this.getCtmPredicate().test(state, side) && (te = world.func_175625_s(pos)) instanceof FramedTileEntity) {
            return ((FramedTileEntity)te).getCamoState();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    default public boolean isSideHidden(IBlockReader world, BlockPos pos, BlockState state, Direction side) {
        IFramedBlock fb;
        if (world == null) {
            return false;
        }
        BlockPos neighborPos = pos.func_177972_a(side);
        BlockState neighborState = world.func_180495_p(neighborPos);
        if (ServerConfig.enableIntangibleFeature && !this.isIntangible(state, world, pos, null) && neighborState.func_177230_c() instanceof IFramedBlock && (fb = (IFramedBlock)neighborState.func_177230_c()).getBlockType().allowMakingIntangible() && fb.isIntangible(neighborState, world, neighborPos, null)) {
            return false;
        }
        SideSkipPredicate pred = ClientConfig.detailedCulling ? this.getBlockType().getSideSkipPredicate() : SideSkipPredicate.CTM;
        return pred.test(world, pos, state, world.func_180495_p(pos.func_177972_a(side)), side);
    }

    default public float getCamoSlipperiness(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        BlockState camoState;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedTileEntity && !(camoState = ((FramedTileEntity)te).getCamoState(Direction.UP)).func_196958_f()) {
            return camoState.getSlipperiness(world, pos, entity);
        }
        return state.func_177230_c().func_208618_m();
    }

    default public float getCamoBlastResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        float resistance;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedTileEntity && (resistance = ((FramedTileEntity)te).getCamoBlastResistance(explosion)) > 0.0f) {
            return resistance;
        }
        return state.func_177230_c().func_149638_a();
    }

    default public boolean isCamoFlammable(IBlockReader world, BlockPos pos, Direction face) {
        if (CommonConfig.fireproofBlocks) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedTileEntity) {
            return ((FramedTileEntity)te).isCamoFlammable(face);
        }
        return true;
    }

    default public int getCamoFlammability(IBlockReader world, BlockPos pos, Direction face) {
        int flammability;
        if (CommonConfig.fireproofBlocks) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedTileEntity && (flammability = ((FramedTileEntity)te).getCamoFlammability(face)) > -1) {
            return flammability;
        }
        return 20;
    }

    default public boolean isIntangible(BlockState state, IBlockReader world, BlockPos pos, @Nullable ISelectionContext ctx) {
        if (!ServerConfig.enableIntangibleFeature || !this.getBlockType().allowMakingIntangible()) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        return te instanceof FramedTileEntity && ((FramedTileEntity)te).isIntangible(ctx);
    }

    default public boolean isSuffocating(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState stateAtPos;
        if (ServerConfig.enableIntangibleFeature && this.getBlockType().allowMakingIntangible() && (state != (stateAtPos = world.func_180495_p(pos)) || this.isIntangible(state, world, pos, null))) {
            return false;
        }
        return state.func_185904_a().func_76230_c() && state.func_235785_r_(world, pos);
    }

    default public IFormattableTextComponent printCamoBlock(CompoundNBT beTag) {
        BlockState camoState = NBTUtil.func_190008_d((CompoundNBT)beTag.func_74775_l("camo_state"));
        return camoState.func_196958_f() ? FramedBlueprintItem.BLOCK_NONE : camoState.func_177230_c().func_235333_g_().func_240699_a_(TextFormatting.WHITE);
    }

    public static boolean suppressParticles(BlockState state, World world, BlockPos pos) {
        if (state.func_177230_c() instanceof IFramedBlock && ((IFramedBlock)state.func_177230_c()).getBlockType().allowMakingIntangible()) {
            return ((IFramedBlock)state.func_177230_c()).isIntangible(state, (IBlockReader)world, pos, null);
        }
        return false;
    }
}

