/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.Utils;

public class FramedSlabEdgeBlock
extends FramedBlock {
    public FramedSlabEdgeBlock() {
        super(BlockType.FRAMED_SLAB_EDGE);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)PropertyHolder.TOP, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.TOP, BlockStateProperties.field_208198_y});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.withTop(this.func_176223_P(), context.func_196000_l(), context.func_221532_j());
        state = (BlockState)state.func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)context.func_195992_f());
        return this.withWater(state, (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    @Override
    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return type == PathType.WATER && world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape bottomShape = FramedSlabEdgeBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
        VoxelShape topShape = FramedSlabEdgeBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            VoxelShape shape = Utils.rotateShape(Direction.NORTH, (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR), (Boolean)state.func_177229_b((Property)PropertyHolder.TOP) != false ? topShape : bottomShape);
            builder.put((Object)state, (Object)shape);
        }
        return builder.build();
    }
}

