/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IWorldReader;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedPillarBlock
extends FramedBlock {
    public FramedPillarBlock(BlockType blockType) {
        super(blockType);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208148_A, BlockStateProperties.field_208198_y});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)context.func_196000_l().func_176740_k());
        return this.withWater(state, (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    public static ImmutableMap<BlockState, VoxelShape> generatePillarShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeX = FramedPillarBlock.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
        VoxelShape shapeY = FramedPillarBlock.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape shapeZ = FramedPillarBlock.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
        for (BlockState state : states) {
            switch ((Direction.Axis)state.func_177229_b((Property)BlockStateProperties.field_208148_A)) {
                case X: {
                    builder.put((Object)state, (Object)shapeX);
                    break;
                }
                case Y: {
                    builder.put((Object)state, (Object)shapeY);
                    break;
                }
                case Z: {
                    builder.put((Object)state, (Object)shapeZ);
                }
            }
        }
        return builder.build();
    }

    public static ImmutableMap<BlockState, VoxelShape> generatePostShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeX = FramedPillarBlock.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
        VoxelShape shapeY = FramedPillarBlock.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape shapeZ = FramedPillarBlock.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
        for (BlockState state : states) {
            switch ((Direction.Axis)state.func_177229_b((Property)BlockStateProperties.field_208148_A)) {
                case X: {
                    builder.put((Object)state, (Object)shapeX);
                    break;
                }
                case Y: {
                    builder.put((Object)state, (Object)shapeY);
                    break;
                }
                case Z: {
                    builder.put((Object)state, (Object)shapeZ);
                }
            }
        }
        return builder.build();
    }
}

