/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.util.mixin;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BreakableBlock;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

@Mixin(value={Block.class})
public abstract class MixinBlock
extends AbstractBlock {
    public MixinBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Inject(method={"shouldSideBeRendered"}, at={@At(value="HEAD")}, cancellable=true)
    private static void framedblocks_shouldSideBeRendered(BlockState state, IBlockReader world, BlockPos pos, Direction face, CallbackInfoReturnable<Boolean> cir) {
        FramedTileEntity fte;
        if (state.func_177230_c() instanceof IFramedBlock || state.func_196958_f() || !(world instanceof ChunkRenderCache)) {
            return;
        }
        BlockPos adjPos = pos.func_177972_a(face);
        TileEntity te = ((ChunkRenderCache)world).func_212399_a(adjPos, Chunk.CreateEntityType.CHECK);
        if (te instanceof FramedTileEntity && !(fte = (FramedTileEntity)te).isIntangible(null)) {
            if (state.func_177230_c() instanceof BreakableBlock && SideSkipPredicate.CTM.test(world, adjPos, world.func_180495_p(adjPos), state, face.func_176734_d())) {
                cir.setReturnValue((Object)false);
            } else if (fte.isSolidSide(face.func_176734_d())) {
                cir.setReturnValue((Object)false);
            }
        }
    }
}

