/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xfacthd.framedblocks.client.util.ClientConfig;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CollapseFace;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.tileentity.FramedCollapsibleTileEntity;
import xfacthd.framedblocks.common.util.Utils;

@Mod.EventBusSubscriber(modid="framedblocks", value={Dist.CLIENT})
public class ClientEventHandler {
    private static final Quaternion ROT_180 = Vector3f.field_229180_c_.func_229187_a_(180.0f);

    @SubscribeEvent
    public static void onRenderBlockHighlight(DrawHighlightEvent.HighlightBlock event) {
        if (!ClientConfig.fancyHitboxes) {
            return;
        }
        BlockRayTraceResult result = event.getTarget();
        BlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(result.func_216350_a());
        if (!(state.func_177230_c() instanceof IFramedBlock)) {
            return;
        }
        BlockType type = ((IFramedBlock)state.func_177230_c()).getBlockType();
        if (type.hasSpecialHitbox()) {
            MatrixStack mstack = event.getMatrix();
            Vector3d offset = Vector3d.func_237491_b_((Vector3i)result.func_216350_a()).func_178788_d(event.getInfo().func_216785_c());
            IVertexBuilder builder = event.getBuffers().getBuffer(RenderType.func_228659_m_());
            mstack.func_227860_a_();
            mstack.func_227861_a_(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            mstack.func_227861_a_(0.5, 0.5, 0.5);
            if (type != BlockType.FRAMED_COLLAPSIBLE_BLOCK) {
                Direction dir = Utils.getBlockFacing(state);
                mstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-dir.func_185119_l()));
            } else {
                mstack.func_227863_a_(ROT_180);
            }
            mstack.func_227861_a_(-0.5, -0.5, -0.5);
            switch (type) {
                case FRAMED_SLOPE: 
                case FRAMED_RAIL_SLOPE: {
                    ClientEventHandler.drawSlopeBox(state, mstack, builder);
                    break;
                }
                case FRAMED_CORNER_SLOPE: {
                    ClientEventHandler.drawCornerSlopeBox(state, mstack, builder);
                    break;
                }
                case FRAMED_INNER_CORNER_SLOPE: {
                    ClientEventHandler.drawInnerCornerSlopeBox(state, mstack, builder);
                    break;
                }
                case FRAMED_PRISM_CORNER: {
                    ClientEventHandler.drawPrismCornerBox(state, mstack, builder);
                    break;
                }
                case FRAMED_INNER_PRISM_CORNER: {
                    ClientEventHandler.drawInnerPrismCornerBox(state, mstack, builder);
                    break;
                }
                case FRAMED_THREEWAY_CORNER: {
                    ClientEventHandler.drawThreewayCornerBox(state, mstack, builder);
                    break;
                }
                case FRAMED_INNER_THREEWAY_CORNER: {
                    ClientEventHandler.drawInnerThreewayCornerBox(state, mstack, builder);
                    break;
                }
                case FRAMED_COLLAPSIBLE_BLOCK: {
                    ClientEventHandler.drawCollapsibleBlockBox(result.func_216350_a(), state, mstack, builder);
                }
            }
            mstack.func_227865_b_();
            event.setCanceled(true);
        }
    }

    private static void drawSlopeBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        SlopeType type = Utils.getSlopeType(state);
        if (type != SlopeType.HORIZONTAL) {
            if (type == SlopeType.TOP) {
                mstack.func_227861_a_(0.5, 0.5, 0.5);
                mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
                mstack.func_227861_a_(-0.5, -0.5, -0.5);
            }
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        } else {
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0);
        }
    }

    private static void drawCornerSlopeBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        CornerType type = (CornerType)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal()) {
            if (type.isTop()) {
                mstack.func_227861_a_(0.5, 0.5, 0.5);
                mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
                mstack.func_227861_a_(-0.5, -0.5, -0.5);
            }
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        } else {
            mstack.func_227861_a_(0.5, 0.5, 0.5);
            if (!type.isRight()) {
                mstack.func_227862_a_(-1.0f, 1.0f, 1.0f);
            }
            if (type.isTop()) {
                mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
            }
            mstack.func_227861_a_(-0.5, -0.5, -0.5);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        }
    }

    private static void drawInnerCornerSlopeBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        CornerType type = (CornerType)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal()) {
            mstack.func_227861_a_(0.5, 0.5, 0.5);
            if (type.isTop()) {
                mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
            }
            mstack.func_227861_a_(-0.5, -0.5, -0.5);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0);
        } else {
            mstack.func_227861_a_(0.5, 0.5, 0.5);
            if (!type.isRight()) {
                mstack.func_227862_a_(-1.0f, 1.0f, 1.0f);
            }
            if (type.isTop()) {
                mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
            }
            mstack.func_227861_a_(-0.5, -0.5, -0.5);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
    }

    private static void drawPrismCornerBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        mstack.func_227861_a_(0.5, 0.5, 0.5);
        if (top) {
            mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
        }
        mstack.func_227861_a_(-0.5, -0.5, -0.5);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
    }

    private static void drawInnerPrismCornerBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        mstack.func_227861_a_(0.5, 0.5, 0.5);
        if (top) {
            mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
        }
        mstack.func_227861_a_(-0.5, -0.5, -0.5);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
    }

    private static void drawThreewayCornerBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        mstack.func_227861_a_(0.5, 0.5, 0.5);
        if (top) {
            mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
        }
        mstack.func_227861_a_(-0.5, -0.5, -0.5);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.5, 0.5, 0.5);
        ClientEventHandler.drawLine(builder, mstack, 0.5, 0.5, 0.5, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.5, 0.5, 0.5);
    }

    private static void drawInnerThreewayCornerBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        mstack.func_227861_a_(0.5, 0.5, 0.5);
        if (top) {
            mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
        }
        mstack.func_227861_a_(-0.5, -0.5, -0.5);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.5, 0.5, 0.5);
        ClientEventHandler.drawLine(builder, mstack, 0.5, 0.5, 0.5, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 0.0, 0.5, 0.5, 0.5);
    }

    public static void drawCollapsibleBlockBox(BlockPos pos, BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        CollapseFace face = (CollapseFace)((Object)state.func_177229_b(PropertyHolder.COLLAPSED_FACE));
        if (face == CollapseFace.NONE) {
            VoxelShapes.func_197868_b().func_197754_a((pMinX, pMinY, pMinZ, pMaxX, pMaxY, pMaxZ) -> ClientEventHandler.drawLine(builder, mstack, pMinX, pMinY, pMinZ, pMaxX, pMaxY, pMaxZ));
        } else {
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
            if (!(te instanceof FramedCollapsibleTileEntity)) {
                return;
            }
            byte[] offets = ((FramedCollapsibleTileEntity)te).getVertexOffsets();
            Direction faceDir = face.toDirection().func_176734_d();
            mstack.func_227860_a_();
            mstack.func_227861_a_(0.5, 0.5, 0.5);
            if (faceDir == Direction.UP) {
                mstack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            } else if (faceDir != Direction.DOWN) {
                mstack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(faceDir.func_185119_l() + 180.0f));
                mstack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(90.0f));
            }
            mstack.func_227861_a_(-0.5, -0.5, -0.5);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0 - (double)offets[2] / 16.0, 0.0, 0.0, 1.0 - (double)offets[3] / 16.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0 - (double)offets[2] / 16.0, 0.0, 1.0, 1.0 - (double)offets[1] / 16.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 1.0 - (double)offets[1] / 16.0, 0.0, 1.0, 1.0 - (double)offets[0] / 16.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0 - (double)offets[3] / 16.0, 1.0, 1.0, 1.0 - (double)offets[0] / 16.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0 - (double)offets[0] / 16.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0 - (double)offets[1] / 16.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0 - (double)offets[2] / 16.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0 - (double)offets[3] / 16.0, 1.0);
            mstack.func_227865_b_();
        }
    }

    private static void drawLine(IVertexBuilder builder, MatrixStack mstack, double x1, double y1, double z1, double x2, double y2, double z2) {
        builder.func_227888_a_(mstack.func_227866_c_().func_227870_a_(), (float)x1, (float)y1, (float)z1).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
        builder.func_227888_a_(mstack.func_227866_c_().func_227870_a_(), (float)x2, (float)y2, (float)z2).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
    }
}

