/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.util;

import com.google.common.base.Preconditions;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.client.util.TriangleDirection;

public class BakedQuadTransformer {
    private static final float SCALE_ROTATION_45 = 1.0f / (float)Math.cos(0.7853981633974483) - 1.0f;
    private static final float SCALE_ROTATION_22_5 = 1.0f / (float)Math.cos(0.39269908169872414) - 1.0f;
    private static final float PRISM_TILT_ANGLE = (float)Math.toDegrees(Math.atan(0.5));
    private static final Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    private static final Vector3f HALF = new Vector3f(0.5f, 0.5f, 0.5f);
    private static final Vector3f[] DIR_TO_ORIGIN_VECS = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)};

    public static void createTopBottomSlopeQuad(BakedQuad quad, boolean up) {
        ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
            Direction dir = quad.func_178210_d();
            int idx = dir.func_176740_k() == Direction.Axis.X ? 0 : 2;
            boolean invert = dir.func_176743_c() == Direction.AxisDirection.POSITIVE == up;
            pos[1][idx] = invert ? 1.0f - pos[1][1] : pos[1][1];
            pos[2][idx] = invert ? 1.0f - pos[2][1] : pos[2][1];
            pos[0][idx] = invert ? 1.0f - pos[0][1] : pos[0][1];
            pos[3][idx] = invert ? 1.0f - pos[3][1] : pos[3][1];
            return true;
        });
    }

    public static void createSideSlopeQuad(BakedQuad quad, boolean rightEdge) {
        ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
            Direction dir = quad.func_178210_d();
            boolean xAxis = dir.func_176740_k() == Direction.Axis.X;
            boolean invert = dir.func_176740_k() == Direction.Axis.Z == rightEdge;
            int srcCoord = xAxis ? 2 : 0;
            int destCoord = xAxis ? 0 : 2;
            pos[0][destCoord] = invert ? 1.0f - pos[0][srcCoord] : pos[0][srcCoord];
            pos[1][destCoord] = invert ? 1.0f - pos[1][srcCoord] : pos[1][srcCoord];
            pos[3][destCoord] = invert ? 1.0f - pos[3][srcCoord] : pos[3][srcCoord];
            pos[2][destCoord] = invert ? 1.0f - pos[2][srcCoord] : pos[2][srcCoord];
            return true;
        });
    }

    public static boolean createSideTriangleQuad(BakedQuad quad, boolean rightSide, boolean top) {
        return ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
            float xz;
            boolean neg;
            int idxTopFront = rightSide ? 0 : 3;
            int idxBotFront = rightSide ? 1 : 2;
            int idxTopBack = rightSide ? 3 : 0;
            int idxBotBack = rightSide ? 2 : 1;
            int idxTargetFront = top ? idxBotFront : idxTopFront;
            int idxTargetBack = top ? idxBotBack : idxTopBack;
            Direction dir = rightSide ? quad.func_178210_d().func_176735_f() : quad.func_178210_d().func_176746_e();
            boolean xAxis = dir.func_176740_k() == Direction.Axis.X;
            boolean bl = neg = dir.func_176743_c() == Direction.AxisDirection.NEGATIVE;
            float f = xAxis ? pos[top ? idxTopBack : idxBotBack][0] : (xz = pos[top ? idxTopBack : idxBotBack][2]);
            if (neg) {
                xz = 1.0f - xz;
            }
            if (top && pos[idxTopBack][1] >= 1.0f - xz || !top && pos[idxBotBack][1] <= xz) {
                float[][] uvSrc = new float[4][2];
                for (int i = 0; i < 4; ++i) {
                    System.arraycopy(uv[i], 0, uvSrc[i], 0, 2);
                }
                boolean rotated = ModelUtils.isQuadRotated(uv);
                boolean mirrored = ModelUtils.isQuadMirrored(uv);
                float f2 = xz = xAxis ? pos[idxBotFront][0] : pos[idxBotFront][2];
                if (neg) {
                    xz = 1.0f - xz;
                }
                float toY = top ? Math.min(Math.max(pos[idxBotFront][1], 1.0f - xz), pos[idxTopFront][1]) : Math.max(Math.min(pos[idxTopFront][1], xz), pos[idxBotFront][1]);
                ModelUtils.remapUV(quad.func_178210_d(), pos[idxBotFront][1], pos[idxTopFront][1], toY, uvSrc, uv, idxTopFront, idxBotFront, idxTargetFront, true, true, rotated, mirrored);
                pos[idxTargetFront][1] = toY;
                float f3 = xz = xAxis ? pos[idxBotBack][0] : pos[idxBotBack][2];
                if (neg) {
                    xz = 1.0f - xz;
                }
                toY = top ? Math.min(Math.max(pos[idxBotBack][1], 1.0f - xz), pos[idxTopBack][1]) : Math.max(Math.min(pos[idxTopBack][1], xz), pos[idxBotBack][1]);
                ModelUtils.remapUV(quad.func_178210_d(), pos[idxTopBack][1], pos[idxBotBack][1], toY, uvSrc, uv, idxTopBack, idxBotBack, idxTargetBack, true, true, rotated, mirrored);
                pos[idxTargetBack][1] = toY;
                return true;
            }
            return false;
        });
    }

    public static boolean createTopBottomTriangleQuad(BakedQuad quad, Direction dir) {
        return ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
            block10: {
                int idxToLeft;
                int idxToRight;
                int idxFromLeft;
                int idxFromRight;
                int coordModifier;
                int coordTarget;
                boolean negModifier;
                boolean negTarget;
                boolean up;
                boolean xAxis;
                block9: {
                    xAxis = dir.func_176740_k() == Direction.Axis.X;
                    up = quad.func_178210_d() == Direction.UP;
                    negTarget = dir.func_176743_c() == Direction.AxisDirection.NEGATIVE;
                    negModifier = dir.func_176746_e().func_176743_c() == Direction.AxisDirection.NEGATIVE;
                    coordTarget = xAxis ? 0 : 2;
                    coordModifier = xAxis ? 2 : 0;
                    idxFromRight = xAxis ? dir.func_176734_d().func_176736_b() : dir.func_176736_b();
                    idxFromLeft = xAxis ? dir.func_176746_e().func_176736_b() : dir.func_176735_f().func_176736_b();
                    idxToRight = xAxis ? dir.func_176735_f().func_176736_b() : dir.func_176746_e().func_176736_b();
                    int n = idxToLeft = !xAxis ? dir.func_176734_d().func_176736_b() : dir.func_176736_b();
                    if (!up && !xAxis) {
                        int temp = idxFromLeft;
                        idxFromLeft = idxToLeft;
                        idxToLeft = temp;
                        temp = idxFromRight;
                        idxFromRight = idxToRight;
                        idxToRight = temp;
                    }
                    float x = pos[idxToLeft][0];
                    if (xAxis && negTarget || !xAxis && negModifier) {
                        x = 1.0f - x;
                    }
                    float z = pos[idxToLeft][2];
                    if (!xAxis && negTarget || xAxis && negModifier) {
                        z = 1.0f - z;
                    }
                    if (xAxis && (!up ? x >= z : x > z)) break block9;
                    if (xAxis || !(z > x)) break block10;
                }
                float[][] uvSrc = new float[4][2];
                for (int i = 0; i < 4; ++i) {
                    System.arraycopy(uv[i], 0, uvSrc[i], 0, 2);
                }
                boolean rotated = ModelUtils.isQuadRotated(uv);
                boolean mirrored = ModelUtils.isQuadMirrored(uv);
                float mod = pos[idxFromLeft][coordModifier];
                if (negModifier) {
                    mod = 1.0f - mod;
                }
                float xz = pos[idxFromLeft][coordTarget];
                float toXZ = negTarget ? Math.min(xz, Math.max(pos[idxToLeft][coordTarget], 1.0f - mod)) : Math.max(xz, Math.min(pos[idxToLeft][coordTarget], mod));
                ModelUtils.remapUV(quad.func_178210_d(), xz, pos[idxToLeft][coordTarget], toXZ, uvSrc, uv, idxFromLeft, idxToLeft, idxFromLeft, !xAxis, !xAxis && !up, rotated, mirrored);
                pos[idxFromLeft][coordTarget] = toXZ;
                mod = pos[idxFromRight][coordModifier];
                if (negModifier) {
                    mod = 1.0f - mod;
                }
                xz = pos[idxFromRight][coordTarget];
                toXZ = negTarget ? Math.min(xz, Math.max(pos[idxToRight][coordTarget], 1.0f - mod)) : Math.max(xz, Math.min(pos[idxToRight][coordTarget], mod));
                ModelUtils.remapUV(quad.func_178210_d(), xz, pos[idxToRight][coordTarget], toXZ, uvSrc, uv, idxFromRight, idxToRight, idxFromRight, !xAxis, !xAxis && !up, rotated, mirrored);
                pos[idxFromRight][coordTarget] = toXZ;
                return true;
            }
            return false;
        });
    }

    public static boolean createPrismTriangleQuad(BakedQuad quad, boolean up, boolean back) {
        float angle;
        boolean useQuad = ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
            float xz2;
            int coord = quad.func_178210_d().func_176740_k() == Direction.Axis.X ? 2 : 0;
            int checkVert1 = up ? 2 : 3;
            int checkVert2 = up ? 1 : 0;
            boolean vertPos = quad.func_178210_d().func_176735_f().func_176743_c() == Direction.AxisDirection.POSITIVE;
            float h1 = (up ? pos[checkVert1][1] : 1.0f - pos[checkVert1][1]) / 2.0f;
            float h2 = 1.0f - (up ? pos[checkVert2][1] : 1.0f - pos[checkVert2][1]) / 2.0f;
            float xz1 = vertPos ? pos[checkVert1][coord] : 1.0f - pos[checkVert1][coord];
            float f = xz2 = vertPos ? pos[checkVert2][coord] : 1.0f - pos[checkVert2][coord];
            if (xz1 >= h1 && xz2 <= h2) {
                boolean northeast = quad.func_178210_d() == Direction.NORTH || quad.func_178210_d() == Direction.EAST;
                int idxTip1 = up ? 0 : 1;
                int idxTip2 = up ? 3 : 2;
                int idxBase1 = up ? 1 : 0;
                int idxBase2 = up ? 2 : 3;
                float yTip1 = (up ? pos[idxTip1][1] : 1.0f - pos[idxTip1][1]) / 2.0f;
                float yTip2 = (up ? pos[idxTip2][1] : 1.0f - pos[idxTip2][1]) / 2.0f;
                float yBase1 = (up ? pos[idxBase1][1] : 1.0f - pos[idxBase1][1]) / 2.0f;
                float yBase2 = (up ? pos[idxBase2][1] : 1.0f - pos[idxBase2][1]) / 2.0f;
                if (northeast) {
                    yTip1 = 1.0f - yTip1;
                    yBase1 = 1.0f - yBase1;
                } else {
                    yTip2 = 1.0f - yTip2;
                    yBase2 = 1.0f - yBase2;
                }
                yTip1 = northeast ? Math.min(yTip1, pos[idxTip1][coord]) : Math.max(yTip1, pos[idxTip1][coord]);
                yTip2 = northeast ? Math.max(yTip2, pos[idxTip2][coord]) : Math.min(yTip2, pos[idxTip2][coord]);
                yBase1 = northeast ? Math.min(yBase1, pos[idxBase1][coord]) : Math.max(yBase1, pos[idxBase1][coord]);
                yBase2 = northeast ? Math.max(yBase2, pos[idxBase2][coord]) : Math.min(yBase2, pos[idxBase2][coord]);
                boolean rotated = ModelUtils.isQuadRotated(uv);
                boolean mirrored = ModelUtils.isQuadMirrored(uv);
                float[][] uvSrc = new float[4][2];
                for (int i = 0; i < 4; ++i) {
                    System.arraycopy(uv[i], 0, uvSrc[i], 0, 2);
                }
                ModelUtils.remapUV(quad.func_178210_d(), pos[idxTip1][coord], pos[idxTip2][coord], yTip1, uvSrc, uv, idxTip1, idxTip2, idxTip1, false, northeast, rotated, mirrored);
                ModelUtils.remapUV(quad.func_178210_d(), pos[idxTip1][coord], pos[idxTip2][coord], yTip2, uvSrc, uv, idxTip1, idxTip2, idxTip2, false, northeast, rotated, mirrored);
                ModelUtils.remapUV(quad.func_178210_d(), pos[idxBase1][coord], pos[idxBase2][coord], yBase1, uvSrc, uv, idxBase1, idxBase2, idxBase1, false, northeast, rotated, mirrored);
                ModelUtils.remapUV(quad.func_178210_d(), pos[idxBase1][coord], pos[idxBase2][coord], yBase2, uvSrc, uv, idxBase1, idxBase2, idxBase2, false, northeast, rotated, mirrored);
                pos[idxTip1][coord] = yTip1;
                pos[idxTip2][coord] = yTip2;
                pos[idxBase1][coord] = yBase1;
                pos[idxBase2][coord] = yBase2;
                return true;
            }
            return false;
        });
        if (!useQuad) {
            return false;
        }
        Vector3f origin = DIR_TO_ORIGIN_VECS[quad.func_178210_d().ordinal() - 2 + (up ? 0 : 4)];
        boolean northeast = quad.func_178210_d() == Direction.NORTH || quad.func_178210_d() == Direction.EAST;
        float f = angle = back ? PRISM_TILT_ANGLE : -PRISM_TILT_ANGLE;
        if (northeast != up) {
            angle *= -1.0f;
        }
        BakedQuadTransformer.rotateQuadAroundAxis(quad, quad.func_178210_d().func_176746_e().func_176740_k(), origin, angle, true);
        BakedQuadTransformer.rotateQuadAroundAxis(quad, Direction.Axis.Y, origin, 45.0f, true);
        return true;
    }

    public static boolean createSmallTriangleQuad(BakedQuad quad, TriangleDirection dir) {
        if (dir.isVertical()) {
            if (!BakedQuadTransformer.createHorizontalSideQuad(quad, dir == TriangleDirection.DOWN, 0.5f)) {
                return false;
            }
        } else {
            Direction cutDir;
            Direction direction = cutDir = dir == TriangleDirection.RIGHT ? quad.func_178210_d().func_176735_f() : quad.func_178210_d().func_176746_e();
            if (!BakedQuadTransformer.createVerticalSideQuad(quad, cutDir, 0.5f)) {
                return false;
            }
        }
        ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
            Direction perpDir = quad.func_178210_d().func_176735_f();
            boolean perpPos = perpDir.func_176743_c() == Direction.AxisDirection.POSITIVE;
            boolean perpXAxis = perpDir.func_176740_k() == Direction.Axis.X;
            boolean rotated = ModelUtils.isQuadRotated(uv);
            boolean mirrored = ModelUtils.isQuadMirrored(uv);
            float[][] uvSrc = new float[4][2];
            for (int i = 0; i < 4; ++i) {
                System.arraycopy(uv[i], 0, uvSrc[i], 0, 2);
            }
            if (dir.isVertical()) {
                boolean up = dir == TriangleDirection.UP;
                int coordTarget = perpXAxis ? 0 : 2;
                float y0 = up ? pos[0][1] : 1.0f - pos[0][1];
                float y1 = up ? pos[1][1] : 1.0f - pos[1][1];
                float y2 = up ? 1.0f - pos[2][1] : pos[2][1];
                float y3 = up ? 1.0f - pos[3][1] : pos[3][1];
                float xz0 = perpPos ? Math.max(Math.min(y0, pos[3][coordTarget]), pos[0][coordTarget]) : Math.min(Math.max(1.0f - y0, pos[3][coordTarget]), pos[0][coordTarget]);
                float xz1 = perpPos ? Math.max(Math.min(y1, pos[2][coordTarget]), pos[1][coordTarget]) : Math.min(Math.max(1.0f - y1, pos[2][coordTarget]), pos[1][coordTarget]);
                float xz2 = perpPos ? Math.min(Math.max(y2, pos[1][coordTarget]), pos[2][coordTarget]) : Math.max(Math.min(1.0f - y2, pos[1][coordTarget]), pos[2][coordTarget]);
                float xz3 = perpPos ? Math.min(Math.max(y3, pos[0][coordTarget]), pos[3][coordTarget]) : Math.max(Math.min(1.0f - y3, pos[0][coordTarget]), pos[3][coordTarget]);
                ModelUtils.remapUV(quad.func_178210_d(), pos[0][coordTarget], pos[3][coordTarget], xz0, uvSrc, uv, 0, 3, 0, false, !perpPos, rotated, mirrored);
                ModelUtils.remapUV(quad.func_178210_d(), pos[1][coordTarget], pos[2][coordTarget], xz1, uvSrc, uv, 1, 2, 1, false, !perpPos, rotated, mirrored);
                ModelUtils.remapUV(quad.func_178210_d(), pos[1][coordTarget], pos[2][coordTarget], xz2, uvSrc, uv, 1, 2, 2, false, !perpPos, rotated, mirrored);
                ModelUtils.remapUV(quad.func_178210_d(), pos[0][coordTarget], pos[3][coordTarget], xz3, uvSrc, uv, 0, 3, 3, false, !perpPos, rotated, mirrored);
                pos[0][coordTarget] = xz0;
                pos[1][coordTarget] = xz1;
                pos[2][coordTarget] = xz2;
                pos[3][coordTarget] = xz3;
            } else {
                boolean right = dir == TriangleDirection.RIGHT;
                int coordSource = perpXAxis ? 0 : 2;
                float xz0 = right == perpPos ? 1.0f - pos[0][coordSource] : pos[0][coordSource];
                float xz1 = right == perpPos ? pos[1][coordSource] : 1.0f - pos[1][coordSource];
                float xz2 = right == perpPos ? pos[2][coordSource] : 1.0f - pos[2][coordSource];
                float xz3 = right == perpPos ? 1.0f - pos[3][coordSource] : pos[3][coordSource];
                float y0 = Math.min(Math.max(xz0, pos[1][1]), pos[0][1]);
                float y1 = Math.max(Math.min(xz1, pos[0][1]), pos[1][1]);
                float y2 = Math.max(Math.min(xz2, pos[3][1]), pos[2][1]);
                float y3 = Math.min(Math.max(xz3, pos[2][1]), pos[3][1]);
                ModelUtils.remapUV(quad.func_178210_d(), pos[0][1], pos[1][1], y0, uvSrc, uv, 0, 1, 0, true, true, rotated, mirrored);
                ModelUtils.remapUV(quad.func_178210_d(), pos[0][1], pos[1][1], y1, uvSrc, uv, 0, 1, 1, true, true, rotated, mirrored);
                ModelUtils.remapUV(quad.func_178210_d(), pos[2][1], pos[3][1], y2, uvSrc, uv, 2, 3, 2, true, true, rotated, mirrored);
                ModelUtils.remapUV(quad.func_178210_d(), pos[2][1], pos[3][1], y3, uvSrc, uv, 2, 3, 3, true, true, rotated, mirrored);
                pos[0][1] = y0;
                pos[1][1] = y1;
                pos[2][1] = y2;
                pos[3][1] = y3;
            }
            return true;
        });
        return true;
    }

    public static boolean createHorizontalSideQuad(BakedQuad quad, boolean top, float height) {
        return BakedQuadTransformer.createHorizontalSideQuad(quad, top, height, height);
    }

    public static boolean createHorizontalSideQuad(BakedQuad quad, boolean top, float heightR, float heightL) {
        return ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
            float factorR;
            boolean positive;
            Direction quadDirRot = quad.func_178210_d().func_176735_f();
            boolean x = quadDirRot.func_176740_k() == Direction.Axis.X;
            boolean bl = positive = quadDirRot.func_176743_c() == Direction.AxisDirection.POSITIVE;
            float f = positive ? pos[0][x ? 0 : 2] : (factorR = 1.0f - pos[0][x ? 0 : 2]);
            float factorL = positive ? pos[3][x ? 0 : 2] : 1.0f - pos[3][x ? 0 : 2];
            float targetR = MathHelper.func_219799_g((float)factorR, (float)(top ? 1.0f - heightR : heightR), (float)(top ? 1.0f - heightL : heightL));
            float targetL = MathHelper.func_219799_g((float)factorL, (float)(top ? 1.0f - heightR : heightR), (float)(top ? 1.0f - heightL : heightL));
            if (top && pos[0][1] >= targetR && pos[3][1] >= targetL || !top && pos[1][1] <= targetR && pos[2][1] <= targetL) {
                int idx1 = top ? 1 : 0;
                int idx2 = top ? 2 : 3;
                float y1 = pos[idx1][1];
                float y2 = pos[idx2][1];
                float toY1 = top ? Math.max(y1, targetR) : Math.min(y1, targetR);
                float toY2 = top ? Math.max(y2, targetL) : Math.min(y2, targetL);
                boolean rotated = ModelUtils.isQuadRotated(uv);
                boolean mirrored = ModelUtils.isQuadMirrored(uv);
                ModelUtils.remapUV(quad.func_178210_d(), pos[1][1], pos[0][1], toY1, uv, 0, 1, idx1, true, true, rotated, mirrored);
                ModelUtils.remapUV(quad.func_178210_d(), pos[2][1], pos[3][1], toY2, uv, 3, 2, idx2, true, true, rotated, mirrored);
                pos[idx1][1] = toY1;
                pos[idx2][1] = toY2;
                return true;
            }
            return false;
        });
    }

    public static boolean createVerticalSideQuad(BakedQuad quad, Direction dir, float length) {
        Preconditions.checkArgument((dir == quad.func_178210_d().func_176746_e() || dir == quad.func_178210_d().func_176735_f() ? 1 : 0) != 0, (Object)"Direction dir must be in the quad's plane!");
        return BakedQuadTransformer.createVerticalSideQuad(quad, dir.func_176743_c() == Direction.AxisDirection.NEGATIVE, length);
    }

    public static boolean createVerticalSideQuad(BakedQuad quad, boolean positive, float length) {
        return BakedQuadTransformer.createVerticalSideQuad(quad, positive, length, length);
    }

    public static boolean createVerticalSideQuad(BakedQuad quad, Direction dir, float lengthTop, float lengthBot) {
        Preconditions.checkArgument((dir == quad.func_178210_d().func_176746_e() || dir == quad.func_178210_d().func_176735_f() ? 1 : 0) != 0, (Object)"Direction dir must be in the quad's plane!");
        return BakedQuadTransformer.createVerticalSideQuad(quad, dir.func_176743_c() == Direction.AxisDirection.NEGATIVE, lengthTop, lengthBot);
    }

    public static boolean createVerticalSideQuad(BakedQuad quad, boolean positive, float lengthTop, float lengthBot) {
        return ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
            int coordIdx = quad.func_178210_d().func_176740_k() == Direction.Axis.X ? 2 : 0;
            boolean right = quad.func_178210_d().func_176735_f().func_176743_c() == Direction.AxisDirection.POSITIVE == positive;
            int vertIdxTop = right ? 3 : 0;
            int vertIdxBot = right ? 2 : 1;
            float targetTop = MathHelper.func_219799_g((float)(1.0f - pos[vertIdxTop][1]), (float)(positive ? 1.0f - lengthTop : lengthTop), (float)(positive ? 1.0f - lengthBot : lengthBot));
            float targetBot = MathHelper.func_219799_g((float)(1.0f - pos[vertIdxBot][1]), (float)(positive ? 1.0f - lengthTop : lengthTop), (float)(positive ? 1.0f - lengthBot : lengthBot));
            if (positive && pos[vertIdxTop][coordIdx] >= targetTop && pos[vertIdxBot][coordIdx] >= targetBot || !positive && pos[vertIdxTop][coordIdx] <= targetTop && pos[vertIdxBot][coordIdx] <= targetBot) {
                int idx1 = right ? 0 : 3;
                int idx2 = right ? 1 : 2;
                float xz1 = pos[idx1][coordIdx];
                float xz2 = pos[idx2][coordIdx];
                float toXZ1 = positive ? Math.max(xz1, targetTop) : Math.min(xz1, targetTop);
                float toXZ2 = positive ? Math.max(xz2, targetBot) : Math.min(xz2, targetBot);
                boolean rotated = ModelUtils.isQuadRotated(uv);
                boolean mirrored = ModelUtils.isQuadMirrored(uv);
                ModelUtils.remapUV(quad.func_178210_d(), pos[0][coordIdx], pos[3][coordIdx], toXZ1, uv, 0, 3, idx1, false, positive != right, rotated, mirrored);
                ModelUtils.remapUV(quad.func_178210_d(), pos[1][coordIdx], pos[2][coordIdx], toXZ2, uv, 1, 2, idx2, false, positive != right, rotated, mirrored);
                pos[idx1][coordIdx] = toXZ1;
                pos[idx2][coordIdx] = toXZ2;
                return true;
            }
            return false;
        });
    }

    public static boolean createTopBottomQuad(BakedQuad quad, Direction cutDir, float length) {
        return BakedQuadTransformer.createTopBottomQuad(quad, cutDir, length, length);
    }

    public static boolean createTopBottomQuad(BakedQuad quad, Direction cutDir, float lengthR, float lengthL) {
        return ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
            int coordIdx;
            int vertIdxR;
            float factorR;
            boolean perpX;
            int idxR;
            boolean up;
            boolean xAxis = cutDir.func_176740_k() == Direction.Axis.X;
            boolean positive = cutDir.func_176743_c() == Direction.AxisDirection.POSITIVE;
            boolean bl = up = quad.func_178210_d() == Direction.UP;
            int n = xAxis ? (positive ? 2 : 1) : (idxR = up == positive ? 1 : 0);
            int idxL = xAxis ? (positive ? 3 : 0) : (up == positive ? 2 : 3);
            Direction perpDir = cutDir.func_176735_f();
            boolean bl2 = perpX = perpDir.func_176740_k() == Direction.Axis.X;
            float f = perpX ? pos[idxR][0] : (factorR = up ? 1.0f - pos[idxR][2] : pos[idxR][2]);
            float factorL = perpX ? pos[idxL][0] : (up ? 1.0f - pos[idxL][2] : pos[idxL][2]);
            float targetR = MathHelper.func_219799_g((float)factorR, (float)(positive ? lengthR : 1.0f - lengthR), (float)(positive ? lengthL : 1.0f - lengthL));
            float targetL = MathHelper.func_219799_g((float)factorL, (float)(positive ? lengthR : 1.0f - lengthR), (float)(positive ? lengthL : 1.0f - lengthL));
            int n2 = xAxis ? (positive ? 1 : 3) : (up ? (positive ? 0 : 2) : (vertIdxR = positive ? 1 : 3));
            int vertIdxL = xAxis ? (positive ? 0 : 2) : (up ? (positive ? 3 : 1) : (positive ? 2 : 0));
            int n3 = coordIdx = xAxis ? 0 : 2;
            if (positive && pos[vertIdxR][coordIdx] <= targetR && pos[vertIdxL][coordIdx] <= targetL || !positive && pos[vertIdxR][coordIdx] >= targetR && pos[vertIdxL][coordIdx] >= targetL) {
                float xz1 = pos[idxR][coordIdx];
                float xz2 = pos[idxL][coordIdx];
                float toXZ1 = positive ? Math.min(xz1, targetR) : Math.max(xz1, targetR);
                float toXZ2 = positive ? Math.min(xz2, targetL) : Math.max(xz2, targetL);
                boolean rotated = ModelUtils.isQuadRotated(uv);
                boolean mirrored = ModelUtils.isQuadMirrored(uv);
                if (xAxis) {
                    ModelUtils.remapUV(quad.func_178210_d(), pos[1][coordIdx], pos[2][coordIdx], toXZ1, uv, 1, 2, idxR, false, false, rotated, mirrored);
                    ModelUtils.remapUV(quad.func_178210_d(), pos[0][coordIdx], pos[3][coordIdx], toXZ2, uv, 0, 3, idxL, false, false, rotated, mirrored);
                } else {
                    ModelUtils.remapUV(quad.func_178210_d(), pos[1][coordIdx], pos[0][coordIdx], toXZ1, uv, 0, 1, idxR, true, !up, rotated, mirrored);
                    ModelUtils.remapUV(quad.func_178210_d(), pos[2][coordIdx], pos[3][coordIdx], toXZ2, uv, 3, 2, idxL, true, !up, rotated, mirrored);
                }
                pos[idxR][coordIdx] = toXZ1;
                pos[idxL][coordIdx] = toXZ2;
                return true;
            }
            return false;
        });
    }

    public static boolean createTopBottomQuad(BakedQuad quad, float minX, float minZ, float maxX, float maxZ) {
        if (minX > 0.0f && !BakedQuadTransformer.createTopBottomQuad(quad, Direction.WEST, 1.0f - minX)) {
            return false;
        }
        if (maxX < 1.0f && !BakedQuadTransformer.createTopBottomQuad(quad, Direction.EAST, maxX)) {
            return false;
        }
        if (minZ > 0.0f && !BakedQuadTransformer.createTopBottomQuad(quad, Direction.NORTH, 1.0f - minZ)) {
            return false;
        }
        return !(maxZ < 1.0f) || BakedQuadTransformer.createTopBottomQuad(quad, Direction.SOUTH, maxZ);
    }

    public static boolean createSideQuad(BakedQuad quad, float minXZ, float minY, float maxXZ, float maxY) {
        if (minXZ > 0.0f && !BakedQuadTransformer.createVerticalSideQuad(quad, true, 1.0f - minXZ)) {
            return false;
        }
        if (maxXZ < 1.0f && !BakedQuadTransformer.createVerticalSideQuad(quad, false, maxXZ)) {
            return false;
        }
        if (minY > 0.0f && !BakedQuadTransformer.createHorizontalSideQuad(quad, true, 1.0f - minY)) {
            return false;
        }
        return !(maxY < 1.0f) || BakedQuadTransformer.createHorizontalSideQuad(quad, false, maxY);
    }

    public static void setQuadPosInFacingDir(BakedQuad quad, float posTarget) {
        int idx = quad.func_178210_d().func_176740_k().ordinal();
        float value = quad.func_178210_d().func_176743_c() == Direction.AxisDirection.POSITIVE ? posTarget : 1.0f - posTarget;
        ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
            for (int i = 0; i < 4; ++i) {
                pos[i][idx] = value;
            }
            return true;
        });
    }

    public static void setVertexPosInFacingDir(BakedQuad quad, float[] posTarget) {
        Preconditions.checkArgument((posTarget.length == 4 ? 1 : 0) != 0, (Object)"Target position array must contain 4 elements!");
        int idx = quad.func_178210_d().func_176740_k().ordinal();
        boolean positive = quad.func_178210_d().func_176743_c() == Direction.AxisDirection.POSITIVE;
        ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
            for (int i = 0; i < 4; ++i) {
                pos[i][idx] = positive ? posTarget[i] : 1.0f - posTarget[i];
            }
            return true;
        });
    }

    public static void offsetQuadInDir(BakedQuad quad, Direction dir, float amount) {
        int idx = dir.func_176740_k().ordinal();
        float value = dir.func_176743_c() == Direction.AxisDirection.POSITIVE ? amount : -1.0f * amount;
        ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
            for (int i = 0; i < 4; ++i) {
                float[] fArray = pos[i];
                int n = idx;
                fArray[n] = fArray[n] + value;
            }
            return true;
        });
    }

    public static void rotateQuadAroundAxisCentered(BakedQuad quad, Direction.Axis axis, float angle, boolean rescale) {
        BakedQuadTransformer.rotateQuadAroundAxis(quad, axis, HALF, angle, rescale);
    }

    public static void rotateQuadAroundAxisCentered(BakedQuad quad, Direction.Axis axis, float angle, boolean rescale, Vector3f scaleMult) {
        BakedQuadTransformer.rotateQuadAroundAxis(quad, axis, HALF, angle, rescale, scaleMult);
    }

    public static void rotateQuadAroundAxis(BakedQuad quad, Direction.Axis axis, Vector3f origin, float angle, boolean rescale) {
        BakedQuadTransformer.rotateQuadAroundAxis(quad, axis, origin, angle, rescale, ONE);
    }

    public static void rotateQuadAroundAxis(BakedQuad quad, Direction.Axis axis, Vector3f origin, float angle, boolean rescale, Vector3f scaleMult) {
        ModelUtils.modifyQuad(quad, (pos, color, uv, light, normal) -> {
            Vector3f scaleVec;
            Vector3f axisVec;
            switch (axis) {
                case X: {
                    axisVec = new Vector3f(1.0f, 0.0f, 0.0f);
                    scaleVec = new Vector3f(0.0f, 1.0f, 1.0f);
                    break;
                }
                case Y: {
                    axisVec = new Vector3f(0.0f, 1.0f, 0.0f);
                    scaleVec = new Vector3f(1.0f, 0.0f, 1.0f);
                    break;
                }
                case Z: {
                    axisVec = new Vector3f(0.0f, 0.0f, 1.0f);
                    scaleVec = new Vector3f(1.0f, 1.0f, 0.0f);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid axis!");
                }
            }
            Matrix4f transform = new Matrix4f(new Quaternion(axisVec, angle, true));
            if (rescale) {
                if (Math.abs(angle) == 22.5f) {
                    scaleVec.func_195898_a(SCALE_ROTATION_22_5);
                } else if (Math.abs(angle) == 45.0f) {
                    scaleVec.func_195898_a(SCALE_ROTATION_45);
                } else {
                    float scaleFactor = 1.0f / (float)Math.cos(Math.PI / (180.0 / (double)angle)) - 1.0f;
                    scaleVec.func_195898_a(scaleFactor);
                }
                scaleMult.func_229191_a_(Math::abs);
                scaleVec.func_229192_b_(scaleMult.func_195899_a(), scaleMult.func_195900_b(), scaleMult.func_195902_c());
                scaleVec.func_195904_b(1.0f, 1.0f, 1.0f);
            }
            for (int i = 0; i < 4; ++i) {
                Vector4f vector4f = new Vector4f(pos[i][0] - origin.func_195899_a(), pos[i][1] - origin.func_195900_b(), pos[i][2] - origin.func_195902_c(), 1.0f);
                if (rescale) {
                    vector4f.func_195909_a(scaleVec);
                }
                vector4f.func_229372_a_(transform);
                pos[i][0] = vector4f.func_195910_a() + origin.func_195899_a();
                pos[i][1] = vector4f.func_195913_b() + origin.func_195900_b();
                pos[i][2] = vector4f.func_195914_c() + origin.func_195902_c();
            }
            return true;
        });
    }
}

