/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.WallHeight;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector4f;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;

public class FramedWallModel
extends FramedBlockModel {
    private static final Vector4f[] rects = new Vector4f[]{new Vector4f(0.3125f, 0.0f, 0.6875f, 0.3125f), new Vector4f(0.3125f, 0.6875f, 0.6875f, 1.0f), new Vector4f(0.0f, 0.3125f, 0.3125f, 0.6875f), new Vector4f(0.6875f, 0.3125f, 1.0f, 0.6875f), new Vector4f(0.3125f, 0.0f, 0.6875f, 0.25f), new Vector4f(0.3125f, 0.75f, 0.6875f, 1.0f), new Vector4f(0.0f, 0.3125f, 0.25f, 0.6875f), new Vector4f(0.75f, 0.3125f, 1.0f, 0.6875f)};
    private final boolean center;
    private final WallHeight north;
    private final WallHeight east;
    private final WallHeight south;
    private final WallHeight west;

    public FramedWallModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.center = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208149_B);
        this.north = (WallHeight)state.func_177229_b((Property)BlockStateProperties.field_235909_T_);
        this.east = (WallHeight)state.func_177229_b((Property)BlockStateProperties.field_235908_S_);
        this.south = (WallHeight)state.func_177229_b((Property)BlockStateProperties.field_235910_U_);
        this.west = (WallHeight)state.func_177229_b((Property)BlockStateProperties.field_235911_V_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (this.north != WallHeight.NONE) {
            this.buildWallHalfSegment(quadMap, quad, Direction.NORTH, this.north);
        }
        if (this.south != WallHeight.NONE) {
            this.buildWallHalfSegment(quadMap, quad, Direction.SOUTH, this.south);
        }
        if (this.east != WallHeight.NONE) {
            this.buildWallHalfSegment(quadMap, quad, Direction.EAST, this.east);
        }
        if (this.west != WallHeight.NONE) {
            this.buildWallHalfSegment(quadMap, quad, Direction.WEST, this.west);
        }
        this.buildWallEndCap(quadMap, quad, Direction.NORTH, this.north);
        this.buildWallEndCap(quadMap, quad, Direction.EAST, this.east);
        this.buildWallEndCap(quadMap, quad, Direction.SOUTH, this.south);
        this.buildWallEndCap(quadMap, quad, Direction.WEST, this.west);
        this.buildCenterPillar(quadMap, quad);
    }

    private void buildWallHalfSegment(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction dir, WallHeight height) {
        if (height != WallHeight.NONE) {
            if (quad.func_178210_d().func_176740_k() == Direction.Axis.Y) {
                Vector4f rect = rects[dir.ordinal() - 2 + (this.center ? 4 : 0)];
                BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, rect.func_195910_a(), rect.func_195913_b(), rect.func_195914_c(), rect.func_195915_d())) {
                    if (height == WallHeight.TALL || quad.func_178210_d() == Direction.DOWN) {
                        quadMap.get(quad.func_178210_d()).add(topBotQuad);
                    } else {
                        BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.875f);
                        quadMap.get(null).add(topBotQuad);
                    }
                }
            } else if (quad.func_178210_d() == dir.func_176746_e() || quad.func_178210_d() == dir.func_176735_f()) {
                BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
                if ((height == WallHeight.TALL || BakedQuadTransformer.createHorizontalSideQuad(sideQuad, false, 0.875f)) && BakedQuadTransformer.createVerticalSideQuad(sideQuad, dir.func_176734_d(), this.center ? 0.25f : 0.3125f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.6875f);
                    quadMap.get(null).add(sideQuad);
                }
            }
        }
    }

    private void buildWallEndCap(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction dir, WallHeight height) {
        BakedQuad sideQuad;
        if (quad.func_178210_d() == dir && height != WallHeight.NONE && BakedQuadTransformer.createSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), 0.3125f, 0.0f, 0.6875f, height == WallHeight.TALL ? 1.0f : 0.875f)) {
            quadMap.get(dir).add(sideQuad);
        }
    }

    private void buildCenterPillar(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (this.center) {
            if (quad.func_178210_d().func_176740_k() == Direction.Axis.Y) {
                BakedQuad pillarQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(pillarQuad, 0.25f, 0.25f, 0.75f, 0.75f)) {
                    quadMap.get(quad.func_178210_d()).add(pillarQuad);
                }
            } else {
                BakedQuad pillarQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideQuad(pillarQuad, 0.25f, 0.0f, 0.75f, 1.0f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(pillarQuad, 0.75f);
                    quadMap.get(null).add(pillarQuad);
                }
            }
        } else {
            boolean tall;
            boolean bl = tall = this.north == WallHeight.TALL || this.east == WallHeight.TALL || this.south == WallHeight.TALL || this.west == WallHeight.TALL;
            if (quad.func_178210_d().func_176740_k() == Direction.Axis.Y) {
                BakedQuad pillarQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(pillarQuad, 0.3125f, 0.3125f, 0.6875f, 0.6875f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(pillarQuad, tall ? 1.0f : 0.875f);
                    quadMap.get(tall ? quad.func_178210_d() : null).add(pillarQuad);
                }
            } else if (quad.func_178210_d() == Direction.NORTH) {
                this.buildSmallCenterSide(quadMap.get(null), quad, this.north, tall);
            } else if (quad.func_178210_d() == Direction.EAST) {
                this.buildSmallCenterSide(quadMap.get(null), quad, this.east, tall);
            } else if (quad.func_178210_d() == Direction.SOUTH) {
                this.buildSmallCenterSide(quadMap.get(null), quad, this.south, tall);
            } else if (quad.func_178210_d() == Direction.WEST) {
                this.buildSmallCenterSide(quadMap.get(null), quad, this.west, tall);
            }
        }
    }

    private void buildSmallCenterSide(List<BakedQuad> quadList, BakedQuad quad, WallHeight height, boolean tall) {
        BakedQuad pillarQuad;
        if (height == WallHeight.NONE) {
            BakedQuad pillarQuad2 = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(pillarQuad2, 0.3125f, 0.0f, 0.6875f, tall ? 1.0f : 0.875f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(pillarQuad2, 0.6875f);
                quadList.add(pillarQuad2);
            }
        } else if (tall && height == WallHeight.LOW && BakedQuadTransformer.createSideQuad(pillarQuad = ModelUtils.duplicateQuad(quad), 0.3125f, 0.875f, 0.6875f, 1.0f)) {
            BakedQuadTransformer.setQuadPosInFacingDir(pillarQuad, 0.6875f);
            quadList.add(pillarQuad);
        }
    }
}

