/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;

public class FramedStairsModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean top;
    private final StairsShape shape;

    public FramedStairsModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        this.top = state.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.TOP;
        this.shape = (StairsShape)state.func_177229_b((Property)BlockStateProperties.field_208146_au);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (this.top && quad.func_178210_d() == Direction.DOWN || !this.top && quad.func_178210_d() == Direction.UP) {
            this.createCenterQuads(quadMap.get(null), quad);
            this.createTopBottomQuads(quadMap.get(quad.func_178210_d()), quad);
        } else if (quad.func_178210_d().func_176740_k() != Direction.Axis.Y) {
            BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createHorizontalSideQuad(sideQuad, this.top, 0.5f)) {
                quadMap.get(quad.func_178210_d()).add(sideQuad);
            }
            this.createSideQuads(quadMap, quad);
        }
    }

    private void createCenterQuads(List<BakedQuad> quadList, BakedQuad quad) {
        BakedQuad topBotQuad;
        if ((this.shape == StairsShape.STRAIGHT || this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.OUTER_RIGHT) && BakedQuadTransformer.createTopBottomQuad(topBotQuad = ModelUtils.duplicateQuad(quad), this.dir, 0.5f)) {
            BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.5f);
            quadList.add(topBotQuad);
        }
        if (this.shape != StairsShape.STRAIGHT) {
            boolean opposite = this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.OUTER_RIGHT;
            boolean left = this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.INNER_LEFT;
            BakedQuad topBotQuad2 = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad2, opposite ? this.dir.func_176734_d() : this.dir, 0.5f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad2, left ? this.dir.func_176735_f() : this.dir.func_176746_e(), 0.5f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad2, 0.5f);
                quadList.add(topBotQuad2);
            }
        }
    }

    private void createTopBottomQuads(List<BakedQuad> quadList, BakedQuad quad) {
        BakedQuad topBotQuad;
        if ((this.shape == StairsShape.STRAIGHT || this.shape == StairsShape.INNER_LEFT || this.shape == StairsShape.INNER_RIGHT) && BakedQuadTransformer.createTopBottomQuad(topBotQuad = ModelUtils.duplicateQuad(quad), this.dir.func_176734_d(), 0.5f)) {
            quadList.add(topBotQuad);
        }
        if (this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.OUTER_RIGHT) {
            topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.func_176734_d(), 0.5f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.shape == StairsShape.OUTER_LEFT ? this.dir.func_176746_e() : this.dir.func_176735_f(), 0.5f)) {
                quadList.add(topBotQuad);
            }
        } else if ((this.shape == StairsShape.INNER_LEFT || this.shape == StairsShape.INNER_RIGHT) && BakedQuadTransformer.createTopBottomQuad(topBotQuad = ModelUtils.duplicateQuad(quad), this.dir, 0.5f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.shape == StairsShape.INNER_LEFT ? this.dir.func_176746_e() : this.dir.func_176735_f(), 0.5f)) {
            quadList.add(topBotQuad);
        }
    }

    private void createSideQuads(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        BakedQuad backQuad;
        if (quad.func_178210_d() == this.dir.func_176734_d()) {
            BakedQuad sideQuad;
            if (this.shape == StairsShape.STRAIGHT) {
                BakedQuad sideQuad2 = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createHorizontalSideQuad(sideQuad2, !this.top, 0.5f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad2, 0.5f);
                    quadMap.get(null).add(sideQuad2);
                }
            } else if (this.shape == StairsShape.INNER_LEFT || this.shape == StairsShape.INNER_RIGHT) {
                BakedQuad sideQuad3 = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createHorizontalSideQuad(sideQuad3, !this.top, 0.5f) && BakedQuadTransformer.createVerticalSideQuad(sideQuad3, this.shape == StairsShape.INNER_LEFT ? this.dir.func_176746_e() : this.dir.func_176735_f(), 0.5f)) {
                    quadMap.get(quad.func_178210_d()).add(sideQuad3);
                }
                if (BakedQuadTransformer.createHorizontalSideQuad(sideQuad3 = ModelUtils.duplicateQuad(quad), !this.top, 0.5f) && BakedQuadTransformer.createVerticalSideQuad(sideQuad3, this.shape == StairsShape.INNER_LEFT ? this.dir.func_176735_f() : this.dir.func_176746_e(), 0.5f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad3, 0.5f);
                    quadMap.get(null).add(sideQuad3);
                }
            } else if ((this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.OUTER_RIGHT) && BakedQuadTransformer.createHorizontalSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), !this.top, 0.5f) && BakedQuadTransformer.createVerticalSideQuad(sideQuad, this.shape == StairsShape.OUTER_LEFT ? this.dir.func_176746_e() : this.dir.func_176735_f(), 0.5f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5f);
                quadMap.get(null).add(sideQuad);
            }
        } else if (quad.func_178210_d() == this.dir.func_176746_e()) {
            BakedQuad sideQuad;
            if (this.shape == StairsShape.OUTER_RIGHT || this.shape == StairsShape.STRAIGHT) {
                BakedQuad sideQuad4 = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createHorizontalSideQuad(sideQuad4, !this.top, 0.5f) && BakedQuadTransformer.createVerticalSideQuad(sideQuad4, this.dir.func_176734_d(), 0.5f)) {
                    quadMap.get(quad.func_178210_d()).add(sideQuad4);
                }
            } else if (this.shape == StairsShape.INNER_LEFT) {
                BakedQuad sideQuad5 = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createHorizontalSideQuad(sideQuad5, !this.top, 0.5f) && BakedQuadTransformer.createVerticalSideQuad(sideQuad5, this.dir.func_176734_d(), 0.5f)) {
                    quadMap.get(quad.func_178210_d()).add(sideQuad5);
                }
                if (BakedQuadTransformer.createHorizontalSideQuad(sideQuad5 = ModelUtils.duplicateQuad(quad), !this.top, 0.5f) && BakedQuadTransformer.createVerticalSideQuad(sideQuad5, this.dir, 0.5f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad5, 0.5f);
                    quadMap.get(null).add(sideQuad5);
                }
            } else if (this.shape == StairsShape.OUTER_LEFT && BakedQuadTransformer.createHorizontalSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), !this.top, 0.5f) && BakedQuadTransformer.createVerticalSideQuad(sideQuad, this.dir.func_176734_d(), 0.5f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5f);
                quadMap.get(null).add(sideQuad);
            }
        } else if (quad.func_178210_d() == this.dir.func_176735_f()) {
            BakedQuad sideQuad;
            if (this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.STRAIGHT) {
                BakedQuad sideQuad6 = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createHorizontalSideQuad(sideQuad6, !this.top, 0.5f) && BakedQuadTransformer.createVerticalSideQuad(sideQuad6, this.dir.func_176734_d(), 0.5f)) {
                    quadMap.get(quad.func_178210_d()).add(sideQuad6);
                }
            } else if (this.shape == StairsShape.INNER_RIGHT) {
                BakedQuad sideQuad7 = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createHorizontalSideQuad(sideQuad7, !this.top, 0.5f) && BakedQuadTransformer.createVerticalSideQuad(sideQuad7, this.dir.func_176734_d(), 0.5f)) {
                    quadMap.get(quad.func_178210_d()).add(sideQuad7);
                }
                if (BakedQuadTransformer.createHorizontalSideQuad(sideQuad7 = ModelUtils.duplicateQuad(quad), !this.top, 0.5f) && BakedQuadTransformer.createVerticalSideQuad(sideQuad7, this.dir, 0.5f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad7, 0.5f);
                    quadMap.get(null).add(sideQuad7);
                }
            } else if (this.shape == StairsShape.OUTER_RIGHT && BakedQuadTransformer.createHorizontalSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), !this.top, 0.5f) && BakedQuadTransformer.createVerticalSideQuad(sideQuad, this.dir.func_176734_d(), 0.5f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5f);
                quadMap.get(null).add(sideQuad);
            }
        } else if (quad.func_178210_d() == this.dir && (this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.OUTER_RIGHT) && BakedQuadTransformer.createHorizontalSideQuad(backQuad = ModelUtils.duplicateQuad(quad), !this.top, 0.5f) && BakedQuadTransformer.createVerticalSideQuad(backQuad, this.shape == StairsShape.OUTER_LEFT ? this.dir.func_176746_e() : this.dir.func_176735_f(), 0.5f)) {
            quadMap.get(quad.func_178210_d()).add(backQuad);
        }
    }
}

