/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedPillarModel
extends FramedBlockModel {
    private final Direction.Axis axis;
    private final float capStart;
    private final float capEnd;
    private final float sideCut;

    public FramedPillarModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.axis = (Direction.Axis)state.func_177229_b((Property)BlockStateProperties.field_208148_A);
        BlockType type = ((IFramedBlock)state.func_177230_c()).getBlockType();
        this.capStart = type == BlockType.FRAMED_POST ? 0.375f : 0.25f;
        this.capEnd = type == BlockType.FRAMED_POST ? 0.625f : 0.75f;
        this.sideCut = type == BlockType.FRAMED_POST ? 0.625f : 0.75f;
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        BakedQuad copy = ModelUtils.duplicateQuad(quad);
        if (FramedPillarModel.createPillarQuad(copy, this.axis, this.capStart, this.capEnd, this.sideCut)) {
            if (quad.func_178210_d().func_176740_k() == this.axis) {
                quadMap.get(quad.func_178210_d()).add(copy);
            } else {
                quadMap.get(null).add(copy);
            }
        }
    }

    public static boolean createPillarQuad(BakedQuad quad, Direction.Axis axis, float capStart, float capEnd, float sideCut) {
        if (quad.func_178210_d().func_176740_k() == axis) {
            if (axis == Direction.Axis.Y) {
                return BakedQuadTransformer.createTopBottomQuad(quad, capStart, capStart, capEnd, capEnd);
            }
            return BakedQuadTransformer.createSideQuad(quad, capStart, capStart, capEnd, capEnd);
        }
        if (axis == Direction.Axis.Y) {
            if (BakedQuadTransformer.createVerticalSideQuad(quad, quad.func_178210_d().func_176746_e(), sideCut) && BakedQuadTransformer.createVerticalSideQuad(quad, quad.func_178210_d().func_176735_f(), sideCut)) {
                BakedQuadTransformer.setQuadPosInFacingDir(quad, sideCut);
                return true;
            }
        } else if (quad.func_178210_d().func_176740_k() == Direction.Axis.Y) {
            if (BakedQuadTransformer.createTopBottomQuad(quad, FramedPillarModel.axisToDir(axis, true).func_176746_e(), sideCut) && BakedQuadTransformer.createTopBottomQuad(quad, FramedPillarModel.axisToDir(axis, false).func_176746_e(), sideCut)) {
                BakedQuadTransformer.setQuadPosInFacingDir(quad, sideCut);
                return true;
            }
        } else if (BakedQuadTransformer.createHorizontalSideQuad(quad, true, sideCut) && BakedQuadTransformer.createHorizontalSideQuad(quad, false, sideCut)) {
            BakedQuadTransformer.setQuadPosInFacingDir(quad, sideCut);
            return true;
        }
        return false;
    }

    private static Direction axisToDir(Direction.Axis axis, boolean positive) {
        switch (axis) {
            case X: {
                return positive ? Direction.EAST : Direction.WEST;
            }
            case Y: {
                return positive ? Direction.UP : Direction.DOWN;
            }
            case Z: {
                return positive ? Direction.SOUTH : Direction.NORTH;
            }
        }
        throw new IllegalArgumentException("Invalid axis!");
    }
}

