/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import xfacthd.framedblocks.client.model.FramedBarsModel;
import xfacthd.framedblocks.client.model.FramedBouncyCubeModel;
import xfacthd.framedblocks.client.model.FramedButtonModel;
import xfacthd.framedblocks.client.model.FramedChestModel;
import xfacthd.framedblocks.client.model.FramedCollapsibleBlockModel;
import xfacthd.framedblocks.client.model.FramedCornerPillarModel;
import xfacthd.framedblocks.client.model.FramedCornerSlopeModel;
import xfacthd.framedblocks.client.model.FramedCubeModel;
import xfacthd.framedblocks.client.model.FramedDoorModel;
import xfacthd.framedblocks.client.model.FramedDoubleCornerModel;
import xfacthd.framedblocks.client.model.FramedDoublePanelModel;
import xfacthd.framedblocks.client.model.FramedDoublePrismCornerModel;
import xfacthd.framedblocks.client.model.FramedDoubleSlabModel;
import xfacthd.framedblocks.client.model.FramedDoubleSlopeModel;
import xfacthd.framedblocks.client.model.FramedDoubleThreewayCornerModel;
import xfacthd.framedblocks.client.model.FramedFenceGateModel;
import xfacthd.framedblocks.client.model.FramedFenceModel;
import xfacthd.framedblocks.client.model.FramedFloorModel;
import xfacthd.framedblocks.client.model.FramedFlowerPotModel;
import xfacthd.framedblocks.client.model.FramedHalfPillarModel;
import xfacthd.framedblocks.client.model.FramedHalfStairsModel;
import xfacthd.framedblocks.client.model.FramedInnerCornerSlopeModel;
import xfacthd.framedblocks.client.model.FramedInnerPrismCornerModel;
import xfacthd.framedblocks.client.model.FramedInnerThreewayCornerModel;
import xfacthd.framedblocks.client.model.FramedLadderModel;
import xfacthd.framedblocks.client.model.FramedLatticeModel;
import xfacthd.framedblocks.client.model.FramedLeverModel;
import xfacthd.framedblocks.client.model.FramedPaneModel;
import xfacthd.framedblocks.client.model.FramedPanelModel;
import xfacthd.framedblocks.client.model.FramedPillarModel;
import xfacthd.framedblocks.client.model.FramedPressurePlateModel;
import xfacthd.framedblocks.client.model.FramedPrismCornerModel;
import xfacthd.framedblocks.client.model.FramedRailSlopeModel;
import xfacthd.framedblocks.client.model.FramedSignModel;
import xfacthd.framedblocks.client.model.FramedSlabCornerModel;
import xfacthd.framedblocks.client.model.FramedSlabEdgeModel;
import xfacthd.framedblocks.client.model.FramedSlabModel;
import xfacthd.framedblocks.client.model.FramedSlopeModel;
import xfacthd.framedblocks.client.model.FramedSoulTorchModel;
import xfacthd.framedblocks.client.model.FramedSoulWallTorchModel;
import xfacthd.framedblocks.client.model.FramedStairsModel;
import xfacthd.framedblocks.client.model.FramedThreewayCornerModel;
import xfacthd.framedblocks.client.model.FramedTorchModel;
import xfacthd.framedblocks.client.model.FramedTrapDoorModel;
import xfacthd.framedblocks.client.model.FramedVerticalStairsModel;
import xfacthd.framedblocks.client.model.FramedWallModel;
import xfacthd.framedblocks.client.model.FramedWallSignModel;
import xfacthd.framedblocks.client.model.FramedWallTorchModel;
import xfacthd.framedblocks.client.render.FramedChestRenderer;
import xfacthd.framedblocks.client.render.FramedSignRenderer;
import xfacthd.framedblocks.client.screen.FramedSignScreen;
import xfacthd.framedblocks.client.screen.FramedStorageScreen;
import xfacthd.framedblocks.client.util.BlueprintPropertyOverride;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.tileentity.FramedDoubleTileEntity;
import xfacthd.framedblocks.common.tileentity.FramedFlowerPotTileEntity;
import xfacthd.framedblocks.common.tileentity.FramedSignTileEntity;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;

@Mod.EventBusSubscriber(modid="framedblocks", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class FBClient {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        FBContent.getRegisteredBlocks().stream().map(RegistryObject::get).filter(block -> block instanceof IFramedBlock).forEach(block -> RenderTypeLookup.setRenderLayer((Block)block, type -> type == RenderType.func_228639_c_() || type == RenderType.func_228643_e_() || type == RenderType.func_228641_d_() || type == RenderType.func_228645_f_()));
        RenderTypeLookup.setRenderLayer((Block)((Block)FBContent.blockFramedGhostBlock.get()), (RenderType)RenderType.func_228645_f_());
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)FBContent.tileTypeFramedSign.get()), FramedSignRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)FBContent.tileTypeFramedChest.get()), FramedChestRenderer::new);
        event.enqueueWork(() -> {
            ScreenManager.func_216911_a((ContainerType)((ContainerType)FBContent.containerTypeFramedChest.get()), FramedStorageScreen::new);
            BlueprintPropertyOverride.register();
        });
    }

    @SubscribeEvent
    public static void onBlockColors(ColorHandlerEvent.Block event) {
        Block[] blocks = (Block[])FBContent.getRegisteredBlocks().stream().map(RegistryObject::get).filter(block -> block instanceof IFramedBlock).toArray(Block[]::new);
        event.getBlockColors().func_186722_a((state, world, pos, tintIndex) -> {
            if (world != null && pos != null) {
                BlockState camoState;
                TileEntity te = world.func_175625_s(pos);
                if (tintIndex < -1) {
                    BlockState plantState;
                    tintIndex = ModelUtils.decodeSecondaryTintIndex(tintIndex);
                    if (te instanceof FramedDoubleTileEntity) {
                        BlockState camoState2 = ((FramedDoubleTileEntity)te).getCamoStateTwo();
                        if (!camoState2.func_196958_f()) {
                            return event.getBlockColors().func_228054_a_(camoState2, world, pos, tintIndex);
                        }
                    } else if (te instanceof FramedFlowerPotTileEntity && !(plantState = ((FramedFlowerPotTileEntity)te).getFlowerBlock().func_176223_P()).func_196958_f()) {
                        return event.getBlockColors().func_228054_a_(plantState, world, pos, tintIndex);
                    }
                } else if (te instanceof FramedTileEntity && !(camoState = ((FramedTileEntity)te).getCamoState()).func_196958_f()) {
                    return event.getBlockColors().func_228054_a_(camoState, world, pos, tintIndex);
                }
            }
            return -1;
        }, blocks);
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
        ModelLoader.addSpecialModel((ResourceLocation)FramedBouncyCubeModel.FRAME_LOCATION);
    }

    @SubscribeEvent
    public static void onModelsLoaded(ModelBakeEvent event) {
        Map registry = event.getModelRegistry();
        FramedChestRenderer.onModelsLoaded(registry);
        FBClient.replaceModels(FBContent.blockFramedCube, registry, FramedCubeModel::new);
        FBClient.replaceModels(FBContent.blockFramedSlope, registry, FramedSlopeModel::new, FramedSlopeModel::new);
        FBClient.replaceModels(FBContent.blockFramedCornerSlope, registry, FramedCornerSlopeModel::new, FramedCornerSlopeModel::new);
        FBClient.replaceModels(FBContent.blockFramedInnerCornerSlope, registry, FramedInnerCornerSlopeModel::new, FramedInnerCornerSlopeModel::new);
        FBClient.replaceModels(FBContent.blockFramedPrismCorner, registry, FramedPrismCornerModel::new, FramedPrismCornerModel::new);
        FBClient.replaceModels(FBContent.blockFramedInnerPrismCorner, registry, FramedInnerPrismCornerModel::new, FramedInnerPrismCornerModel::new);
        FBClient.replaceModels(FBContent.blockFramedThreewayCorner, registry, FramedThreewayCornerModel::new, FramedThreewayCornerModel::new);
        FBClient.replaceModels(FBContent.blockFramedInnerThreewayCorner, registry, FramedInnerThreewayCornerModel::new, FramedInnerThreewayCornerModel::new);
        FBClient.replaceModels(FBContent.blockFramedSlab, registry, FramedSlabModel::new);
        FBClient.replaceModels(FBContent.blockFramedSlabEdge, registry, FramedSlabEdgeModel::new);
        FBClient.replaceModels(FBContent.blockFramedSlabCorner, registry, FramedSlabCornerModel::new);
        FBClient.replaceModels(FBContent.blockFramedPanel, registry, FramedPanelModel::new);
        FBClient.replaceModels(FBContent.blockFramedCornerPillar, registry, FramedCornerPillarModel::new);
        FBClient.replaceModels(FBContent.blockFramedStairs, registry, FramedStairsModel::new);
        FBClient.replaceModels(FBContent.blockFramedWall, registry, FramedWallModel::new);
        FBClient.replaceModels(FBContent.blockFramedFence, registry, FramedFenceModel::createFenceModel);
        FBClient.replaceModels(FBContent.blockFramedGate, registry, FramedFenceGateModel::new);
        FBClient.replaceModels(FBContent.blockFramedDoor, registry, FramedDoorModel::new);
        FBClient.replaceModels(FBContent.blockFramedTrapDoor, registry, FramedTrapDoorModel::new);
        FBClient.replaceModels(FBContent.blockFramedPressurePlate, registry, FramedPressurePlateModel::new);
        FBClient.replaceModels(FBContent.blockFramedLadder, registry, FramedLadderModel::new, FramedLadderModel::new);
        FBClient.replaceModels(FBContent.blockFramedButton, registry, FramedButtonModel::new);
        FBClient.replaceModels(FBContent.blockFramedLever, registry, FramedLeverModel::new);
        FBClient.replaceModels(FBContent.blockFramedSign, registry, FramedSignModel::new);
        FBClient.replaceModels(FBContent.blockFramedWallSign, registry, FramedWallSignModel::new);
        FBClient.replaceModels(FBContent.blockFramedDoubleSlab, registry, FramedDoubleSlabModel::new);
        FBClient.replaceModels(FBContent.blockFramedDoublePanel, registry, FramedDoublePanelModel::new);
        FBClient.replaceModels(FBContent.blockFramedDoubleSlope, registry, FramedDoubleSlopeModel::new);
        FBClient.replaceModels(FBContent.blockFramedDoubleCorner, registry, FramedDoubleCornerModel::new, FramedDoubleCornerModel::new);
        FBClient.replaceModels(FBContent.blockFramedDoublePrismCorner, registry, FramedDoublePrismCornerModel::new, FramedDoublePrismCornerModel::new);
        FBClient.replaceModels(FBContent.blockFramedDoubleThreewayCorner, registry, FramedDoubleThreewayCornerModel::new, FramedDoubleThreewayCornerModel::new);
        FBClient.replaceModels(FBContent.blockFramedTorch, registry, FramedTorchModel::new);
        FBClient.replaceModels(FBContent.blockFramedWallTorch, registry, FramedWallTorchModel::new);
        FBClient.replaceModels(FBContent.blockFramedSoulTorch, registry, FramedSoulTorchModel::new);
        FBClient.replaceModels(FBContent.blockFramedSoulWallTorch, registry, FramedSoulWallTorchModel::new);
        FBClient.replaceModels(FBContent.blockFramedFloor, registry, FramedFloorModel::new);
        FBClient.replaceModels(FBContent.blockFramedLattice, registry, FramedLatticeModel::new);
        FBClient.replaceModels(FBContent.blockFramedVerticalStairs, registry, FramedVerticalStairsModel::new);
        FBClient.replaceModels(FBContent.blockFramedChest, registry, FramedChestModel::new, FramedChestModel::new);
        FBClient.replaceModels(FBContent.blockFramedBars, registry, FramedBarsModel::new);
        FBClient.replaceModels(FBContent.blockFramedPane, registry, FramedPaneModel::new);
        FBClient.replaceModels(FBContent.blockFramedRailSlope, registry, FramedRailSlopeModel::new, FramedRailSlopeModel::new);
        FBClient.replaceModels(FBContent.blockFramedFlowerPot, registry, FramedFlowerPotModel::new);
        FBClient.replaceModels(FBContent.blockFramedPillar, registry, FramedPillarModel::new);
        FBClient.replaceModels(FBContent.blockFramedHalfPillar, registry, FramedHalfPillarModel::new);
        FBClient.replaceModels(FBContent.blockFramedPost, registry, FramedPillarModel::new);
        FBClient.replaceModels(FBContent.blockFramedCollapsibleBlock, registry, FramedCollapsibleBlockModel::new);
        FBClient.replaceModels(FBContent.blockFramedHalfStairs, registry, FramedHalfStairsModel::new);
        FBClient.replaceModels(FBContent.blockFramedBouncyCube, registry, (state, model) -> new FramedBouncyCubeModel((BlockState)state, (IBakedModel)model, registry));
        FBClient.replaceModels(FBContent.blockFramedSecretStorage, registry, FramedCubeModel::new);
    }

    private static void replaceModels(RegistryObject<Block> block, Map<ResourceLocation, IBakedModel> models, BiFunction<BlockState, IBakedModel, IBakedModel> blockModelGen) {
        FBClient.replaceModels(block, models, blockModelGen, model -> model);
    }

    private static void replaceModels(RegistryObject<Block> block, Map<ResourceLocation, IBakedModel> models, BiFunction<BlockState, IBakedModel, IBakedModel> blockModelGen, Function<IBakedModel, IBakedModel> itemModelGen) {
        for (BlockState state : ((Block)block.get()).func_176194_O().func_177619_a()) {
            ModelResourceLocation location = BlockModelShapes.func_209554_c((BlockState)state);
            IBakedModel baseModel = models.get(location);
            IBakedModel replacement = blockModelGen.apply(state, baseModel);
            models.put((ResourceLocation)location, replacement);
        }
        ModelResourceLocation location = new ModelResourceLocation(((Block)block.get()).getRegistryName(), "inventory");
        IBakedModel replacement = itemModelGen.apply(models.get(location));
        models.put((ResourceLocation)location, replacement);
    }

    public static void openSignScreen(BlockPos pos) {
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
        if (te instanceof FramedSignTileEntity) {
            Minecraft.func_71410_x().func_147108_a((Screen)new FramedSignScreen((FramedSignTileEntity)te));
        }
    }
}

