/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands.variants;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.worldgen.islands.variants.AbstractSlimeIslandVariant;

public class SkySlimeIslandVariant
extends AbstractSlimeIslandVariant {
    public SkySlimeIslandVariant(int index, SlimeType dirtType) {
        super(index, dirtType, SlimeType.SKY);
    }

    @Override
    public ResourceLocation getStructureName(String variantName) {
        return TConstruct.getResource("slime_islands/sky/" + this.dirtType.func_176610_l() + "_" + variantName);
    }

    @Override
    protected SlimeType getCongealedSlimeType(Random random) {
        return random.nextBoolean() ? SlimeType.SKY : SlimeType.EARTH;
    }

    @Override
    public BlockState getLakeFluid() {
        return Objects.requireNonNull(TinkerFluids.skySlime.getBlock()).func_176223_P();
    }

    @Override
    @Nullable
    public BlockState getVines() {
        return ((SlimeVineBlock)TinkerWorld.skySlimeVine.get()).func_176223_P();
    }

    @Override
    @Nullable
    public ConfiguredFeature<?, ?> getTreeFeature(Random random) {
        return TinkerStructures.SKY_SLIME_ISLAND_TREE;
    }
}

