/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.tconstruct.common.recipe.LoggingRecipeSerializer;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ArmorDyeingRecipe
implements ITinkerStationRecipe,
IMultiRecipe<IDisplayModifierRecipe> {
    private final ResourceLocation id;
    private final Ingredient toolRequirement;
    @Nullable
    private List<IDisplayModifierRecipe> displayRecipes;

    @Override
    public boolean matches(ITinkerStationInventory inv, World world) {
        if (!this.toolRequirement.test(inv.getTinkerableStack())) {
            return false;
        }
        boolean found = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack input = inv.getInput(i);
            if (input.func_190926_b()) continue;
            if (!Tags.Items.DYES.func_230235_a_((Object)input.func_77973_b())) {
                return false;
            }
            found = true;
        }
        return found;
    }

    @Override
    public ItemStack getCraftingResult(ITinkerStationInventory inv) {
        ToolStack tool = ToolStack.copyFrom(inv.getTinkerableStack());
        ModDataNBT persistentData = tool.getPersistentData();
        ResourceLocation key = TinkerModifiers.dyed.getId();
        int nr = 0;
        int nb = 0;
        int ng = 0;
        int brightness = 0;
        int count = 0;
        if (persistentData.contains(key, 3)) {
            int color = persistentData.getInt(key);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            brightness = Math.max(r, Math.max(g, b));
            nr = r;
            nb = b;
            ng = g;
            ++count;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            DyeColor dye;
            ItemStack stack = inv.getInput(i);
            if (stack.func_190926_b() || (dye = DyeColor.getColor((ItemStack)stack)) == null) continue;
            float[] color = dye.func_193349_f();
            int r = (int)(color[0] * 255.0f);
            int g = (int)(color[1] * 255.0f);
            int b = (int)(color[2] * 255.0f);
            brightness += Math.max(r, Math.max(g, b));
            nr += r;
            ng += g;
            nb += b;
            ++count;
        }
        if (count == 0) {
            return ItemStack.field_190927_a;
        }
        float scaledBrightness = (float)brightness / (float)count;
        brightness = Math.max(nr /= count, Math.max(ng /= count, nb /= count));
        nr = (int)((float)nr * scaledBrightness / (float)brightness);
        ng = (int)((float)ng * scaledBrightness / (float)brightness);
        nb = (int)((float)nb * scaledBrightness / (float)brightness);
        int finalColor = nr << 16 | ng << 8 | nb;
        persistentData.putInt(key, finalColor);
        Modifier modifier = (Modifier)TinkerModifiers.dyed.get();
        if (tool.getModifierLevel(modifier) == 0) {
            tool.addModifier(modifier, 1);
        }
        return tool.createStack();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerModifiers.armorDyeingSerializer.get();
    }

    public List<IDisplayModifierRecipe> getRecipes() {
        if (this.displayRecipes == null) {
            List toolInputs = Arrays.stream(this.toolRequirement.func_193365_a()).map(stack -> {
                if (stack.func_77973_b() instanceof IModifiableDisplay) {
                    return ((IModifiableDisplay)stack.func_77973_b()).getRenderTool();
                }
                return stack;
            }).collect(Collectors.toList());
            ModifierEntry result = new ModifierEntry((Modifier)TinkerModifiers.dyed.get(), 1);
            this.displayRecipes = Arrays.stream(DyeColor.values()).map(dye -> new DisplayRecipe(result, toolInputs, (DyeColor)dye)).collect(Collectors.toList());
        }
        return this.displayRecipes;
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ArmorDyeingRecipe(ResourceLocation id, Ingredient toolRequirement) {
        this.id = id;
        this.toolRequirement = toolRequirement;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    private static class DisplayRecipe
    implements IDisplayModifierRecipe {
        private static final int[] TINT_COLORS = new int[16];
        private final ModifierEntry displayResult;
        private final List<List<ItemStack>> displayItems;
        private final List<ItemStack> toolWithModifier;

        private static int getTintColor(DyeColor color) {
            int id = color.func_196059_a();
            if (TINT_COLORS[id] == 0) {
                float[] colors = color.func_193349_f();
                DisplayRecipe.TINT_COLORS[id] = (int)(colors[0] * 255.0f) << 16 | (int)(colors[1] * 255.0f) << 8 | (int)(colors[2] * 255.0f);
            }
            return TINT_COLORS[id];
        }

        public DisplayRecipe(ModifierEntry result, List<ItemStack> tools, DyeColor color) {
            this.displayResult = result;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add(tools);
            builder.add(color.getTag().func_230236_b_().stream().map(ItemStack::new).collect(Collectors.toList()));
            this.displayItems = builder.build();
            ModifierId id = result.getModifier().getId();
            int tintColor = DisplayRecipe.getTintColor(color);
            this.toolWithModifier = tools.stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, null, result, data -> data.putInt(id, tintColor))).collect(Collectors.toList());
        }

        @Override
        public int getMaxLevel() {
            return 1;
        }

        @Override
        public ModifierEntry getDisplayResult() {
            return this.displayResult;
        }

        @Override
        public List<List<ItemStack>> getDisplayItems() {
            return this.displayItems;
        }

        @Override
        public List<ItemStack> getToolWithModifier() {
            return this.toolWithModifier;
        }
    }

    public static class Finished
    implements IFinishedRecipe {
        private final ResourceLocation ID;
        private final Ingredient toolRequirement;

        public void func_218610_a(JsonObject json) {
            json.add("tools", this.toolRequirement.func_200304_c());
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)TinkerModifiers.armorDyeingSerializer.get();
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }

        public Finished(ResourceLocation ID, Ingredient toolRequirement) {
            this.ID = ID;
            this.toolRequirement = toolRequirement;
        }

        public ResourceLocation func_200442_b() {
            return this.ID;
        }
    }

    public static class Serializer
    extends LoggingRecipeSerializer<ArmorDyeingRecipe> {
        @Override
        @Nullable
        protected ArmorDyeingRecipe readSafe(ResourceLocation id, PacketBuffer buffer) {
            Ingredient toolRequirement = Ingredient.func_199566_b((PacketBuffer)buffer);
            return new ArmorDyeingRecipe(id, toolRequirement);
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, ArmorDyeingRecipe recipe) {
            recipe.toolRequirement.func_199564_a(buffer);
        }

        public ArmorDyeingRecipe read(ResourceLocation id, JsonObject json) {
            Ingredient toolRequirement = Ingredient.func_199802_a((JsonElement)json.get("tools"));
            return new ArmorDyeingRecipe(id, toolRequirement);
        }
    }
}

