/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class RagingModifier
extends Modifier {
    private static final float LOWEST_HEALTH = 2.0f;
    private static final float HIGHEST_HEALTH = 10.0f;
    private static final float DAMAGE_PER_LEVEL = 4.0f;

    public RagingModifier() {
        super(0xB30000);
    }

    private static float getBonus(LivingEntity attacker, int level) {
        float health = attacker.func_110143_aJ();
        float max = attacker.func_110138_aP();
        if (max < 10.0f) {
            health += 10.0f - max;
        }
        if (health <= 2.0f) {
            return (float)level * 4.0f;
        }
        if (health < 10.0f) {
            return (float)level * 4.0f * (10.0f - health) / 8.0f;
        }
        return 0.0f;
    }

    @Override
    public float getEntityDamage(IModifierToolStack tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        return damage + RagingModifier.getBonus(context.getAttacker(), level);
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, @Nullable PlayerEntity player, List<ITextComponent> tooltip, TooltipKey key, TooltipFlag flag) {
        float bonus = level * 4;
        if (player != null && key == TooltipKey.SHIFT) {
            bonus = RagingModifier.getBonus((LivingEntity)player, level);
        }
        this.addDamageTooltip(tool, bonus, tooltip);
    }
}

