/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.slotless;

import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.DurabilityShieldModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class OverslimeModifier
extends DurabilityShieldModifier {
    private static final ResourceLocation KEY_OVERSLIME_CAP = TConstruct.getResource("overslime_cap");
    private static final ResourceLocation KEY_OVERSLIME_FRIEND = TConstruct.getResource("overslime_friend");

    protected OverslimeModifier(int color) {
        super(color);
    }

    public OverslimeModifier() {
        this(7462021);
    }

    @Override
    public ITextComponent getDisplayName(int level) {
        return super.getDisplayName();
    }

    @Override
    public void addVolatileData(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, int level, ModDataNBT volatileData) {
        this.addCapacity(volatileData, (int)(50.0f * toolDefinition.getData().getMultiplier(ToolStats.DURABILITY)));
    }

    @Override
    public void addToolStats(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, IModDataReadOnly volatileData, int level, ModifierStatsBuilder builder) {
        if (!volatileData.getBoolean(KEY_OVERSLIME_FRIEND)) {
            ToolStats.ATTACK_DAMAGE.multiply(builder, 0.9f);
            ToolStats.MINING_SPEED.multiply(builder, 0.9f);
        }
    }

    @Override
    public int getPriority() {
        return 150;
    }

    @Override
    @Nullable
    public Boolean showDurabilityBar(IModifierToolStack tool, int level) {
        return this.getOverslime(tool) < this.getCapacity(tool);
    }

    @Override
    public int getDurabilityRGB(IModifierToolStack tool, int level) {
        if (this.getOverslime(tool) > 0) {
            return 53503;
        }
        return -1;
    }

    @Deprecated
    public ResourceLocation getOverslimeKey() {
        return this.getId();
    }

    @Override
    protected ResourceLocation getShieldKey() {
        return this.getOverslimeKey();
    }

    public ResourceLocation getCapacityKey() {
        return KEY_OVERSLIME_CAP;
    }

    public ResourceLocation getFriendKey() {
        return KEY_OVERSLIME_FRIEND;
    }

    public void setFriend(ModDataNBT volatileData) {
        volatileData.putBoolean(this.getFriendKey(), true);
    }

    public int getCapacity(IModDataReadOnly volatileData) {
        return volatileData.getInt(this.getCapacityKey());
    }

    public int getCapacity(IModifierToolStack tool) {
        return this.getCapacity(tool.getVolatileData());
    }

    @Override
    protected int getShieldCapacity(IModifierToolStack tool, int level) {
        return this.getCapacity(tool);
    }

    public void setCapacity(ModDataNBT volatileData, int amount) {
        volatileData.putInt(KEY_OVERSLIME_CAP, amount);
    }

    public void addCapacity(ModDataNBT volatileData, int amount) {
        this.setCapacity(volatileData, this.getCapacity(volatileData) + amount);
    }

    public void multiplyCapacity(ModDataNBT volatileData, float factor) {
        volatileData.putInt(KEY_OVERSLIME_CAP, (int)((float)this.getCapacity(volatileData) * factor));
    }

    public int getOverslime(IModifierToolStack tool) {
        return this.getShield(tool);
    }

    @Deprecated
    public void setOverslime(ModDataNBT persistentData, int amount) {
        this.setShield(persistentData, amount);
    }

    public void setOverslime(IModifierToolStack tool, int amount) {
        this.setShield(tool, 0, amount);
    }

    public void addOverslime(IModifierToolStack tool, int amount) {
        int overworked = tool.getModifierLevel((Modifier)TinkerModifiers.overworked.get());
        this.addShield(tool, 0, amount * (1 + overworked));
    }
}

