/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.IncrementalModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.tools.logic.ModifierMaxLevel;
import slimeknights.tconstruct.tools.logic.VanillaMaxLevel;
import slimeknights.tconstruct.tools.modifiers.defense.ProtectionModifier;

public class FireProtectionModifier
extends IncrementalModifier {
    private static final TinkerDataCapability.TinkerDataKey<FireData> FIRE_DATA = TConstruct.createKey("fire_protection");

    public FireProtectionModifier() {
        super(5196359);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, LivingEvent.LivingUpdateEvent.class, FireProtectionModifier::livingTick);
    }

    @Override
    public float getProtectionModifier(IModifierToolStack tool, int level, EquipmentContext context, EquipmentSlotType slotType, DamageSource source, float modifierValue) {
        if (!source.func_151517_h() && !source.func_76357_e() && source.func_76347_k()) {
            modifierValue += this.getScaledLevel(tool, level) * 2.0f;
        }
        return modifierValue;
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, TooltipFlag tooltipFlag) {
        ProtectionModifier.addResistanceTooltip(this, tool, level, 2.0f, tooltip);
    }

    private int getEnchantmentLevel(EquipmentChangeContext context, EquipmentSlotType slotType) {
        if (context.getToolInSlot(slotType) == null) {
            return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77329_d, (ItemStack)context.getEntity().func_184582_a(slotType));
        }
        return 0;
    }

    @Override
    public void onUnequip(IModifierToolStack tool, int level, EquipmentChangeContext context) {
        LivingEntity entity = context.getEntity();
        EquipmentSlotType slot = context.getChangedSlot();
        if (slot.func_188453_a() == EquipmentSlotType.Group.ARMOR && !entity.func_130014_f_().field_72995_K) {
            context.getTinkerData().ifPresent(data -> {
                FireData fireData = data.get(FIRE_DATA);
                if (fireData != null) {
                    fireData.modifier.set(slot, 0.0f);
                    if (fireData.modifier.getMax() == 0.0f) {
                        data.remove(FIRE_DATA);
                    }
                }
            });
        }
    }

    @Override
    public void onEquip(IModifierToolStack tool, int level, EquipmentChangeContext context) {
        LivingEntity entity = context.getEntity();
        EquipmentSlotType slot = context.getChangedSlot();
        if (!entity.func_130014_f_().field_72995_K && slot.func_188453_a() == EquipmentSlotType.Group.ARMOR && !tool.isBroken()) {
            float scaledLevel = this.getScaledLevel(tool, level);
            context.getTinkerData().ifPresent(data -> {
                FireData fireData = data.get(FIRE_DATA);
                if (fireData == null) {
                    fireData = new FireData();
                    for (EquipmentSlotType slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                        fireData.vanilla.set(slotType, this.getEnchantmentLevel(context, slotType));
                    }
                    int fireTimer = entity.func_223314_ad();
                    if (fireTimer > 0) {
                        fireData.finish = entity.field_70173_aa + fireTimer + 1;
                    }
                    data.put(FIRE_DATA, fireData);
                }
                fireData.modifier.set(slot, scaledLevel);
                fireData.vanilla.set(slot, 0);
            });
        }
    }

    @Override
    public void onEquipmentChange(IModifierToolStack tool, int level, EquipmentChangeContext context, EquipmentSlotType slotType) {
        LivingEntity entity = context.getEntity();
        EquipmentSlotType slot = context.getChangedSlot();
        if (!entity.func_130014_f_().field_72995_K && slot.func_188453_a() == EquipmentSlotType.Group.ARMOR) {
            context.getTinkerData().ifPresent(data -> {
                FireData fireData = data.get(FIRE_DATA);
                if (fireData != null && fireData.modifier.getMaxSlot() == slotType) {
                    fireData.vanilla.set(slot, this.getEnchantmentLevel(context, slot));
                }
            });
        }
    }

    private static void livingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!entity.func_130014_f_().field_72995_K && !entity.func_175149_v()) {
            entity.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                float maxLevel;
                int maxVanilla;
                FireData fireData = data.get(FIRE_DATA);
                if (fireData != null && (float)(maxVanilla = fireData.vanilla.getMax()) < (maxLevel = fireData.modifier.getMax())) {
                    int currentFire = entity.func_223314_ad();
                    if (currentFire <= 0) {
                        if (fireData.finish > entity.field_70173_aa) {
                            fireData.finish = 0;
                        }
                    } else if (currentFire + entity.field_70173_aa > fireData.finish) {
                        int newFire = currentFire;
                        newFire = maxVanilla > 0 ? (newFire -= MathHelper.func_76141_d((float)((float)currentFire / (1.0f - (float)maxVanilla * 0.15f) * (maxLevel - (float)maxVanilla) * 0.15f))) : (newFire -= MathHelper.func_76141_d((float)((float)currentFire * maxLevel * 0.15f)));
                        if (newFire < 0) {
                            newFire = 0;
                            fireData.finish = 0;
                        } else {
                            fireData.finish = newFire + entity.field_70173_aa + 1;
                        }
                        entity.func_241209_g_(newFire);
                    }
                }
            });
        }
    }

    protected static class FireData {
        public final ModifierMaxLevel modifier = new ModifierMaxLevel();
        public final VanillaMaxLevel vanilla = new VanillaMaxLevel();
        int finish = 0;

        protected FireData() {
        }
    }
}

