/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.logic;

import java.util.List;
import java.util.Objects;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorWalkModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.helper.ArmorUtil;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.BlockSideHitListener;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.upgrades.harvest.HasteModifier;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ToolEvents {
    @SubscribeEvent
    static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        float armorHaste;
        List<ModifierEntry> modifiers;
        ToolStack tool;
        ItemStack stack;
        PlayerEntity player = event.getPlayer();
        if (player.func_208600_a((ITag)FluidTags.field_206959_a) && ModifierUtil.getTotalModifierLevel((LivingEntity)player, TinkerDataKeys.AQUA_AFFINITY) > 0 && !EnchantmentHelper.func_185287_i((LivingEntity)player)) {
            event.setNewSpeed(event.getNewSpeed() * 5.0f);
        }
        if (TinkerTags.Items.HARVEST.func_230235_a_((Object)(stack = player.func_184614_ca()).func_77973_b()) && !(tool = ToolStack.from(stack)).isBroken() && !(modifiers = tool.getModifierList()).isEmpty()) {
            float miningSpeedModifier = Modifier.getMiningModifier((LivingEntity)player);
            boolean isEffective = stack.func_150998_b(event.getState());
            Direction direction = BlockSideHitListener.getSideHit(player);
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().onBreakSpeed(tool, entry.getLevel(), event, direction, isEffective, miningSpeedModifier);
                if (!event.isCanceled()) continue;
                return;
            }
        }
        if ((armorHaste = ModifierUtil.getTotalModifierFloat((LivingEntity)player, HasteModifier.HASTE)) > 0.0f) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f + 0.1f * armorHaste));
        }
    }

    @SubscribeEvent
    static void onHarvest(TinkerToolEvent.ToolHarvestEvent event) {
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        BlockState state = event.getState();
        Block block = state.func_177230_c();
        ServerWorld world = event.getWorld();
        BlockPos pos = event.getPos();
        if (block == Blocks.field_150423_aK) {
            Direction facing = event.getContext().func_196000_l();
            if (facing.func_176740_k() == Direction.Axis.Y) {
                facing = event.getContext().func_195992_f().func_176734_d();
            }
            world.func_184133_a(null, pos, SoundEvents.field_199059_fV, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_180501_a(pos, (BlockState)Blocks.field_196625_cS.func_176223_P().func_206870_a((Property)CarvedPumpkinBlock.field_196359_a, (Comparable)facing), 11);
            ItemEntity itemEntity = new ItemEntity((World)world, (double)pos.func_177958_n() + 0.5 + (double)facing.func_82601_c() * 0.65, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5 + (double)facing.func_82599_e() * 0.65, new ItemStack((IItemProvider)Items.field_151080_bb, 4));
            itemEntity.func_213293_j(0.05 * (double)facing.func_82601_c() + world.field_73012_v.nextDouble() * 0.02, 0.05, 0.05 * (double)facing.func_82599_e() + world.field_73012_v.nextDouble() * 0.02);
            world.func_217376_c((Entity)itemEntity);
            event.setResult(Event.Result.ALLOW);
        }
        if (block instanceof BeehiveBlock) {
            BeehiveBlock beehive = (BeehiveBlock)block;
            int level = (Integer)state.func_177229_b((Property)BeehiveBlock.field_226873_c_);
            if (level >= 5) {
                world.func_184133_a(null, pos, SoundEvents.field_226133_ah_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Items.field_226635_pU_, 3));
                if (!CampfireBlock.func_235474_a_((World)world, (BlockPos)pos)) {
                    if (beehive.func_226882_d_((World)world, pos)) {
                        beehive.func_226881_b_((World)world, pos);
                    }
                    beehive.func_226877_a_((World)world, state, pos, event.getPlayer(), BeehiveTileEntity.State.EMERGENCY);
                } else {
                    beehive.func_226876_a_((World)world, state, pos);
                }
                event.setResult(Event.Result.ALLOW);
            } else {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    static void enderDragonDamage(LivingDamageEvent event) {
        DamageSource source;
        LivingEntity entity = event.getEntityLiving();
        if (entity.func_200600_R() == EntityType.field_200802_p && event.getAmount() > 0.0f && !entity.func_130014_f_().field_72995_K && (source = event.getSource()).func_94541_c() && source.func_76346_g() != null && source.func_76346_g().func_200600_R() == EntityType.field_200729_aH) {
            ModifierUtil.dropItem((Entity)entity, new ItemStack(TinkerModifiers.dragonScale, 1 + entity.func_130014_f_().field_73012_v.nextInt(8)));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void livingAttack(LivingAttackEvent event) {
        Entity attacker;
        LivingEntity entity = event.getEntityLiving();
        if (entity.field_70170_p.func_201670_d() || entity.func_233643_dh_()) {
            return;
        }
        DamageSource source = event.getSource();
        if (entity.func_180431_b(source)) {
            return;
        }
        boolean isDirectDamage = source.func_76346_g() != null && source instanceof EntityDamageSource && !((EntityDamageSource)source).func_180139_w();
        EquipmentContext context = new EquipmentContext(entity);
        float amount = event.getAmount();
        if (context.hasModifiableArmor()) {
            IModifierToolStack toolStack;
            for (EquipmentSlotType slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                toolStack = context.getToolInSlot(slotType);
                if (toolStack == null || toolStack.isBroken()) continue;
                for (ModifierEntry entry : toolStack.getModifierList()) {
                    if (!entry.getModifier().isSourceBlocked(toolStack, entry.getLevel(), context, slotType, source, amount)) continue;
                    event.setCanceled(true);
                    return;
                }
            }
            for (EquipmentSlotType slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                toolStack = context.getToolInSlot(slotType);
                if (toolStack == null || toolStack.isBroken()) continue;
                for (ModifierEntry entry : toolStack.getModifierList()) {
                    entry.getModifier().onAttacked(toolStack, entry.getLevel(), context, slotType, source, amount, isDirectDamage);
                }
            }
        }
        if ((attacker = source.func_76346_g()) instanceof LivingEntity && (context = new EquipmentContext((LivingEntity)attacker)).hasModifiableArmor()) {
            for (EquipmentSlotType slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                IModifierToolStack toolStack = context.getToolInSlot(slotType);
                if (toolStack == null || toolStack.isBroken()) continue;
                for (ModifierEntry entry : toolStack.getModifierList()) {
                    entry.getModifier().attackWithArmor(toolStack, entry.getLevel(), context, slotType, entity, source, amount, isDirectDamage);
                }
            }
        }
    }

    private static int getArmorDamage(float damage) {
        if ((damage /= 4.0f) < 1.0f) {
            return 1;
        }
        return (int)damage;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void livingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntityLiving();
        EquipmentContext context = new EquipmentContext(entity);
        if (!context.hasModifiableArmor()) {
            return;
        }
        DamageSource source = event.getSource();
        int vanillaModifier = 0;
        if (!source.func_151517_h()) {
            vanillaModifier = EnchantmentHelper.func_77508_a((Iterable)entity.func_184193_aE(), (DamageSource)source);
        }
        float modifierValue = vanillaModifier;
        float originalDamage = event.getAmount();
        for (EquipmentSlotType slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
            IModifierToolStack tool = context.getToolInSlot(slotType);
            if (tool == null || tool.isBroken()) continue;
            for (ModifierEntry entry : tool.getModifierList()) {
                modifierValue = entry.getModifier().getProtectionModifier(tool, entry.getLevel(), context, slotType, source, modifierValue);
            }
        }
        if ((float)vanillaModifier != modifierValue) {
            int damageMissed;
            float armor = 0.0f;
            float toughness = 0.0f;
            if (!source.func_76363_c()) {
                armor = entity.func_70658_aO();
                toughness = (float)entity.func_233637_b_(Attributes.field_233827_j_);
            }
            float finalDamage = ArmorUtil.getDamageForEvent(originalDamage, armor, toughness, vanillaModifier, modifierValue);
            event.setAmount(finalDamage);
            if (!source.func_76363_c() && (damageMissed = ToolEvents.getArmorDamage(originalDamage) - ToolEvents.getArmorDamage(finalDamage)) > 0 && entity instanceof PlayerEntity) {
                for (EquipmentSlotType slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                    IModifierToolStack tool = context.getToolInSlot(slotType);
                    if (!(tool == null || source.func_76347_k() && tool.getItem().func_234687_u_())) {
                        ToolDamageUtil.damageAnimated(tool, damageMissed, entity, slotType);
                        continue;
                    }
                    ItemStack armorStack = entity.func_184582_a(slotType);
                    if (armorStack.func_190926_b() || source.func_76347_k() && armorStack.func_77973_b().func_234687_u_() || !(armorStack.func_77973_b() instanceof ArmorItem)) continue;
                    armorStack.func_222118_a(damageMissed, entity, e -> e.func_213361_c(slotType));
                }
            }
        }
    }

    @SubscribeEvent
    static void livingWalk(LivingEvent.LivingUpdateEvent event) {
        ItemStack boots;
        LivingEntity living = event.getEntityLiving();
        if (living.func_175149_v()) {
            return;
        }
        BlockPos pos = living.func_233580_cy_();
        if (!living.field_70170_p.func_201670_d() && living.func_70089_S() && !Objects.equals(living.field_184620_bC, pos) && !(boots = living.func_184582_a(EquipmentSlotType.FEET)).func_190926_b() && TinkerTags.Items.BOOTS.func_230235_a_((Object)boots.func_77973_b())) {
            ToolStack tool = ToolStack.from(boots);
            for (ModifierEntry entry : tool.getModifierList()) {
                IArmorWalkModifier hook = entry.getModifier().getModule(IArmorWalkModifier.class);
                if (hook == null) continue;
                hook.onWalk(tool, entry.getLevel(), living, living.field_184620_bC, pos);
            }
        }
    }
}

