/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.GenericHeadModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.tools.client.ArmorModelWrapper;

public class SlimeskullArmorModel<T extends LivingEntity>
extends ArmorModelWrapper<T> {
    private static final SlimeskullArmorModel<LivingEntity> INSTANCE = new SlimeskullArmorModel();
    @Nullable
    private ResourceLocation headTexture;
    @Nullable
    private GenericHeadModel headModel;
    private static final Map<MaterialId, Pair<ResourceLocation, GenericHeadModel>> HEAD_MODELS = new HashMap<MaterialId, Pair<ResourceLocation, GenericHeadModel>>();

    public static <A extends BipedModel<?>> A getModel(ItemStack stack, A baseModel) {
        INSTANCE.setToolAndBase(stack, baseModel);
        return (A)((Object)INSTANCE);
    }

    @Override
    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.base != null) {
            this.copyToBase();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, this.field_217114_e ? -0.015 : -0.02, 0.0);
            matrixStackIn.func_227862_a_(1.01f, 1.0f, 1.01f);
            this.base.func_225598_a_(matrixStackIn, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStackIn.func_227865_b_();
        }
        if (this.headModel != null && this.headTexture != null && buffer != null) {
            boolean needsPush;
            IVertexBuilder headBuilder = buffer.getBuffer(RenderType.func_239267_e_((ResourceLocation)this.headTexture));
            boolean bl = needsPush = this.field_217114_e || this.field_228270_o_ && this.base != null;
            if (needsPush) {
                matrixStackIn.func_227860_a_();
                if (this.field_217114_e) {
                    matrixStackIn.func_227862_a_(0.75f, 0.75f, 0.75f);
                    matrixStackIn.func_227861_a_(0.0, 1.0, 0.0);
                }
                if (this.field_228270_o_ && this.base != null) {
                    matrixStackIn.func_227861_a_(0.0, (double)(this.base.field_78116_c.field_78797_d / 16.0f), 0.0);
                }
            }
            this.headModel.func_225603_a_(0.0f, this.field_78116_c.field_78796_g * 180.0f / (float)Math.PI, this.field_78116_c.field_78795_f * 180.0f / (float)Math.PI);
            this.headModel.func_225598_a_(matrixStackIn, headBuilder, packedLightIn, packedOverlayIn, red, green * 0.5f, blue, alpha * 0.8f);
            if (needsPush) {
                matrixStackIn.func_227865_b_();
            }
        }
    }

    public void setToolAndBase(ItemStack stack, BipedModel<?> base) {
        Pair<ResourceLocation, GenericHeadModel> pair;
        this.base = base;
        MaterialId materialId = MaterialIdNBT.from(stack).getMaterial(0);
        if (!materialId.equals((Object)IMaterial.UNKNOWN_ID) && (pair = HEAD_MODELS.get((Object)materialId)) != null) {
            this.headTexture = (ResourceLocation)pair.getFirst();
            this.headModel = (GenericHeadModel)pair.getSecond();
            return;
        }
        this.headTexture = null;
        this.headModel = null;
    }

    public static void registerHeadModel(MaterialId materialId, GenericHeadModel headModel, ResourceLocation texture) {
        if (HEAD_MODELS.containsKey((Object)materialId)) {
            throw new IllegalArgumentException("Duplicate head model " + (Object)((Object)materialId));
        }
        HEAD_MODELS.put(materialId, (Pair<ResourceLocation, GenericHeadModel>)Pair.of((Object)texture, (Object)headModel));
    }
}

