/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.module;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.ModuleScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.mantle.client.screen.SliderWidget;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.tables.client.inventory.module.BorderWidget;
import slimeknights.tconstruct.tables.client.inventory.module.GenericScreen;

public class SideInventoryScreen<P extends MultiModuleScreen<?>, C extends Container>
extends ModuleScreen<P, C> {
    protected ScalableElementScreen overlap = GenericScreen.overlap;
    protected ElementScreen overlapTopLeft = GenericScreen.overlapTopLeft;
    protected ElementScreen overlapTopRight = GenericScreen.overlapTopRight;
    protected ElementScreen overlapBottomLeft = GenericScreen.overlapBottomLeft;
    protected ElementScreen overlapBottomRight = GenericScreen.overlapBottomRight;
    protected ElementScreen overlapTop = new ElementScreen(7, 0, 7, 7, 64, 64);
    protected ScalableElementScreen textBackground = GenericScreen.textBackground;
    protected ScalableElementScreen slot = GenericScreen.slot;
    protected ScalableElementScreen slotEmpty = GenericScreen.slotEmpty;
    protected ElementScreen sliderNormal = GenericScreen.sliderNormal;
    protected ElementScreen sliderLow = GenericScreen.sliderLow;
    protected ElementScreen sliderHigh = GenericScreen.sliderHigh;
    protected ElementScreen sliderTop = GenericScreen.sliderTop;
    protected ElementScreen sliderBottom = GenericScreen.sliderBottom;
    protected ScalableElementScreen sliderBackground = GenericScreen.sliderBackground;
    protected static final ResourceLocation GENERIC_INVENTORY = TConstruct.getResource("textures/gui/generic.png");
    protected BorderWidget border = new BorderWidget();
    protected int columns;
    protected int slotCount;
    protected int firstSlotId;
    protected int lastSlotId;
    protected int yOffset;
    protected int xOffset;
    protected boolean connected;
    protected SliderWidget slider = new SliderWidget(this.sliderNormal, this.sliderHigh, this.sliderLow, this.sliderTop, this.sliderBottom, this.sliderBackground);

    public SideInventoryScreen(P parent, C container, PlayerInventory playerInventory, ITextComponent title, int slotCount, int columns) {
        this(parent, container, playerInventory, title, slotCount, columns, false, false);
    }

    public SideInventoryScreen(P parent, C container, PlayerInventory playerInventory, ITextComponent title, int slotCount, int columns, boolean rightSide, boolean connected) {
        super(parent, container, playerInventory, title, rightSide, false);
        this.connected = connected;
        this.columns = columns;
        this.slotCount = slotCount;
        this.field_146999_f = columns * this.slot.w + this.border.w * 2;
        this.field_147000_g = this.calcCappedYSize(this.slot.h * 10);
        if (connected) {
            if (this.right) {
                this.border.cornerTopLeft = this.overlapTopLeft;
                this.border.borderLeft = this.overlap;
                this.border.cornerBottomLeft = this.overlapBottomLeft;
            } else {
                this.border.cornerTopRight = this.overlapTopRight;
                this.border.borderRight = this.overlap;
                this.border.cornerBottomRight = this.overlapBottomRight;
            }
        }
        this.yOffset = 0;
        this.updateSlots();
    }

    protected boolean shouldDrawName() {
        return this.field_147002_h instanceof BaseContainer;
    }

    public boolean shouldDrawSlot(Slot slot) {
        if (slot.getSlotIndex() >= this.slotCount) {
            return false;
        }
        if (!this.slider.isEnabled()) {
            return true;
        }
        return this.firstSlotId <= slot.getSlotIndex() && this.lastSlotId > slot.getSlotIndex();
    }

    public boolean func_195362_a(Slot slotIn, double mouseX, double mouseY) {
        return super.func_195362_a(slotIn, mouseX, mouseY) && this.shouldDrawSlot(slotIn);
    }

    public void updateSlotCount(int newSlotCount) {
        if (this.slotCount == newSlotCount) {
            return;
        }
        this.slotCount = newSlotCount;
        this.updatePosition(this.parent.cornerX, this.parent.cornerY, this.parent.realWidth, this.parent.realHeight);
        this.updatePosition(this.parent.cornerX, this.parent.cornerY, this.parent.realWidth, this.parent.realHeight);
    }

    public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
        this.field_147000_g = this.calcCappedYSize(parentSizeY - 10);
        if (this.getDisplayedRows() < this.getTotalRows()) {
            this.slider.enable();
            this.field_146999_f = this.columns * this.slot.w + this.slider.width + 2 * this.border.w;
        } else {
            this.slider.disable();
            this.field_146999_f = this.columns * this.slot.w + this.border.w * 2;
        }
        super.updatePosition(parentX, parentY, parentSizeX, parentSizeY);
        if (this.connected) {
            if (this.yOffset == 0) {
                if (this.right) {
                    this.border.cornerTopLeft = this.overlapTop;
                } else {
                    this.border.cornerTopRight = this.overlapTop;
                }
            }
            this.xOffset = (this.border.w - 1) * (this.right ? -1 : 1);
            this.field_147003_i += this.xOffset;
        } else {
            this.xOffset = 0;
        }
        this.field_147009_r += this.yOffset;
        this.border.setPosition(this.field_147003_i, this.field_147009_r);
        this.border.setSize(this.field_146999_f, this.field_147000_g);
        int y = this.field_147009_r + this.border.h;
        int h = this.field_147000_g - this.border.h * 2;
        if (this.shouldDrawName()) {
            y += this.textBackground.h;
            h -= this.textBackground.h;
        }
        this.slider.setPosition(this.field_147003_i + this.columns * this.slot.w + this.border.w, y);
        this.slider.setSize(h);
        this.slider.setSliderParameters(0, this.getTotalRows() - this.getDisplayedRows(), 1);
        this.updateSlots();
    }

    private int getDisplayedRows() {
        return this.slider.height / this.slot.h;
    }

    private int getTotalRows() {
        int total = this.slotCount / this.columns;
        if (this.slotCount % this.columns != 0) {
            ++total;
        }
        return total;
    }

    private int calcCappedYSize(int max) {
        int h = this.slot.h * this.getTotalRows();
        h = this.border.getHeightWithBorder(h);
        if (this.shouldDrawName()) {
            h += this.textBackground.h;
        }
        while (h > max) {
            h -= this.slot.h;
        }
        return h;
    }

    protected void updateSlots() {
        this.firstSlotId = this.slider.getValue() * this.columns;
        this.lastSlotId = Math.min(this.slotCount, this.firstSlotId + this.getDisplayedRows() * this.columns);
        int xd = this.border.w + this.xOffset;
        int yd = this.border.h + this.yOffset;
        if (this.shouldDrawName()) {
            yd += this.textBackground.h;
        }
        for (Slot slot : this.field_147002_h.field_75151_b) {
            if (this.shouldDrawSlot(slot)) {
                int offset = slot.getSlotIndex() - this.firstSlotId;
                int x = offset % this.columns * this.slot.w;
                int y = offset / this.columns * this.slot.h;
                slot.field_75223_e = xd + x + 1;
                slot.field_75221_f = yd + y + 1;
                if (this.right) {
                    slot.field_75223_e += this.parent.realWidth;
                    continue;
                }
                slot.field_75223_e -= this.field_146999_f;
                continue;
            }
            slot.field_75223_e = 0;
            slot.field_75221_f = 0;
        }
    }

    public void func_230451_b_(MatrixStack matrices, int mouseX, int mouseY) {
        if (this.shouldDrawName()) {
            this.field_230712_o_.func_238421_b_(matrices, this.func_231171_q_().getString(), (float)this.border.w, (float)(this.border.h - 1), 0x404040);
        }
    }

    protected void func_230450_a_(MatrixStack matrices, float partialTicks, int mouseX, int mouseY) {
        this.field_147003_i += this.border.w;
        this.field_147009_r += this.border.h;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GENERIC_INVENTORY);
        int x = this.field_147003_i;
        int y = this.field_147009_r;
        int midW = this.field_146999_f - this.border.w * 2;
        this.border.draw(matrices);
        if (this.shouldDrawName()) {
            this.textBackground.drawScaledX(matrices, x, y, midW);
            y += this.textBackground.h;
        }
        this.field_230706_i_.func_110434_K().func_110577_a(GENERIC_INVENTORY);
        this.drawSlots(matrices, x, y);
        if (this.slider.isEnabled()) {
            this.slider.update(mouseX, mouseY);
            this.slider.draw(matrices);
            this.updateSlots();
        }
        this.field_147003_i -= this.border.w;
        this.field_147009_r -= this.border.h;
    }

    protected int drawSlots(MatrixStack matrices, int xPos, int yPos) {
        int y;
        int width = this.columns * this.slot.w;
        int height = this.field_147000_g - this.border.h * 2;
        int fullRows = (this.lastSlotId - this.firstSlotId) / this.columns;
        for (y = 0; y < fullRows * this.slot.h && y < height; y += this.slot.h) {
            this.slot.drawScaledX(matrices, xPos, yPos + y, width);
        }
        int slotsLeft = (this.lastSlotId - this.firstSlotId) % this.columns;
        if (slotsLeft > 0) {
            this.slot.drawScaledX(matrices, xPos, yPos + y, slotsLeft * this.slot.w);
            this.slotEmpty.drawScaledX(matrices, xPos + slotsLeft * this.slot.w, yPos + y, width - slotsLeft * this.slot.w);
        }
        return width;
    }

    public boolean handleMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.slider.isEnabled()) {
            this.slider.handleMouseClicked((int)mouseX, (int)mouseY, mouseButton);
        }
        return super.handleMouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean handleMouseReleased(double mouseX, double mouseY, int state) {
        if (this.slider.isEnabled()) {
            this.slider.handleMouseReleased();
        }
        return super.handleMouseReleased(mouseX, mouseY, state);
    }

    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollData) {
        if (!this.slider.isEnabled()) {
            return super.handleMouseScrolled(mouseX, mouseY, scrollData);
        }
        return this.slider.mouseScrolled(scrollData, !this.isMouseOverFullSlot(mouseX, mouseY) && this.isMouseInModule((int)mouseX, (int)mouseY));
    }

    public int getSlotCount() {
        return this.slotCount;
    }
}

