/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.inventory;

import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import slimeknights.mantle.inventory.SingleItemHandler;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.InventorySlotSyncPacket;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.smeltery.tileentity.component.DuctTileEntity;

public class DuctItemHandler
extends SingleItemHandler<DuctTileEntity> {
    public DuctItemHandler(DuctTileEntity parent) {
        super((MantleTileEntity)parent, 1);
    }

    public void setStack(ItemStack newStack) {
        World world = ((DuctTileEntity)this.parent).func_145831_w();
        boolean hasChange = world != null && !ItemStack.func_77989_b((ItemStack)this.getStack(), (ItemStack)newStack);
        super.setStack(newStack);
        if (hasChange) {
            if (!world.field_72995_K) {
                BlockPos pos = ((DuctTileEntity)this.parent).func_174877_v();
                TinkerNetwork.getInstance().sendToClientsAround(new InventorySlotSyncPacket(newStack, 0, pos), (IWorld)world, pos);
            } else {
                ((DuctTileEntity)this.parent).updateFluid();
            }
        }
    }

    protected boolean isItemValid(ItemStack stack) {
        ItemStack container;
        if (!(stack.func_77973_b().func_206844_a(TinkerTags.Items.DUCT_CONTAINERS) || !(container = stack.getContainerItem()).func_190926_b() && container.func_77973_b().func_206844_a(TinkerTags.Items.DUCT_CONTAINERS))) {
            return false;
        }
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).filter(cap -> !cap.getFluidInTank(0).isEmpty()).isPresent();
    }

    public FluidStack getFluid() {
        ItemStack stack = this.getStack();
        if (stack.func_190926_b()) {
            return FluidStack.EMPTY;
        }
        return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> handler.getFluidInTank(0)).orElse(FluidStack.EMPTY);
    }
}

