/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;
import slimeknights.tconstruct.smeltery.tileentity.FaucetTileEntity;

public class FaucetActivationPacket
extends FluidUpdatePacket {
    private final boolean isPouring;

    public FaucetActivationPacket(BlockPos pos, FluidStack fluid, boolean isPouring) {
        super(pos, fluid);
        this.isPouring = isPouring;
    }

    public FaucetActivationPacket(PacketBuffer buffer) {
        super(buffer);
        this.isPouring = buffer.readBoolean();
    }

    @Override
    public void encode(PacketBuffer packetBuffer) {
        super.encode(packetBuffer);
        packetBuffer.writeBoolean(this.isPouring);
    }

    @Override
    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(FaucetActivationPacket packet) {
            assert (Minecraft.func_71410_x().field_71441_e != null);
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(packet.pos);
            if (te instanceof FaucetTileEntity) {
                ((FaucetTileEntity)te).onActivationPacket(packet.fluid, packet.isPouring);
            }
        }
    }
}

