/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.controller;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.fluid.FluidTransferUtil;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.tileentity.ITankTileEntity;

public abstract class TinyMultiblockControllerBlock
extends ControllerBlock {
    private static final ITextComponent NO_FUEL_TANK = TConstruct.makeTranslation("multiblock", "tiny.no_fuel_tank");

    protected TinyMultiblockControllerBlock(AbstractBlock.Properties builder) {
        super(builder);
    }

    protected boolean isValidFuelSource(BlockState state) {
        return TinkerTags.Blocks.FUEL_TANKS.func_230235_a_((Object)state.func_177230_c());
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        if (state != null) {
            return (BlockState)state.func_206870_a((Property)IN_STRUCTURE, (Comparable)Boolean.valueOf(this.isValidFuelSource(context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b()))));
        }
        return null;
    }

    @Deprecated
    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighbor, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN) {
            return (BlockState)state.func_206870_a((Property)IN_STRUCTURE, (Comparable)Boolean.valueOf(this.isValidFuelSource(neighbor)));
        }
        return state;
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (FluidTransferUtil.interactWithTank(world, pos, player, hand, hit)) {
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    @Override
    protected boolean displayStatus(PlayerEntity player, World world, BlockPos pos, BlockState state) {
        if (!world.field_72995_K && !((Boolean)state.func_177229_b((Property)IN_STRUCTURE)).booleanValue()) {
            player.func_146105_b(NO_FUEL_TANK, true);
        }
        return true;
    }

    @Deprecated
    public boolean func_149740_M(BlockState state) {
        return true;
    }

    @Deprecated
    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return ITankTileEntity.getComparatorInputOverride((IWorld)worldIn, pos);
    }
}

