/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.subcommand;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.shared.command.HeldModifiableItemIterator;
import slimeknights.tconstruct.shared.command.argument.ToolStatArgument;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.slotless.StatOverrideModifier;

public class StatsCommand {
    private static final String SUCCESS_KEY_PREFIX = TConstruct.makeTranslationKey("command", "stats.success.");
    private static final String RESET_ALL_SINGLE = TConstruct.makeTranslationKey("command", "stats.success.reset.all.single");
    private static final String RESET_ALL_MULTIPLE = TConstruct.makeTranslationKey("command", "stats.success.reset.all.multiple");
    private static final String RESET_STAT_SINGLE = TConstruct.makeTranslationKey("command", "stats.success.reset.stat.single");
    private static final String RESET_STAT_MULTIPLE = TConstruct.makeTranslationKey("command", "stats.success.reset.stat.multiple");
    private static final SimpleCommandExceptionType INVALID_ADD = new SimpleCommandExceptionType((Message)TConstruct.makeTranslation("command", "stats.failure.invalid_add"));
    private static final SimpleCommandExceptionType INVALID_MULTIPLY = new SimpleCommandExceptionType((Message)TConstruct.makeTranslation("command", "stats.failure.invalid_multiply"));
    private static final DynamicCommandExceptionType MODIFIER_ERROR = new DynamicCommandExceptionType(error -> (ITextComponent)error);

    public static void register(LiteralArgumentBuilder<CommandSource> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.func_197034_c(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"bonus").then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"stat_type", ToolStatArgument.stat()).then(Commands.func_197056_a((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> StatsCommand.update((CommandContext<CommandSource>)context, Type.BONUS, Operation.MODIFY)))))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"stat_type", ToolStatArgument.stat()).then(Commands.func_197056_a((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> StatsCommand.update((CommandContext<CommandSource>)context, Type.BONUS, Operation.SET))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"multiplier").then(Commands.func_197057_a((String)"multiply").then(Commands.func_197056_a((String)"float_stat", ToolStatArgument.stat(FloatToolStat.class)).then(Commands.func_197056_a((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> StatsCommand.update((CommandContext<CommandSource>)context, Type.MULTIPLY, Operation.MODIFY)))))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"float_stat", ToolStatArgument.stat(FloatToolStat.class)).then(Commands.func_197056_a((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> StatsCommand.update((CommandContext<CommandSource>)context, Type.MULTIPLY, Operation.SET))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"reset").executes(StatsCommand::resetAll)).then(Commands.func_197056_a((String)"stat_type", ToolStatArgument.stat()).executes(StatsCommand::resetStat))));
    }

    private static int update(CommandContext<CommandSource> context, Type type, Operation op) throws CommandSyntaxException {
        float value = FloatArgumentType.getFloat(context, (String)"value");
        if (op == Operation.MODIFY) {
            if (value == 0.0f && type == Type.BONUS) {
                throw INVALID_ADD.create();
            }
            if (value == 1.0f && type == Type.MULTIPLY) {
                throw INVALID_MULTIPLY.create();
            }
        }
        IToolStat<?> stat = ToolStatArgument.getStat(context, type.stat);
        List<LivingEntity> successes = HeldModifiableItemIterator.apply(context, (living, stack) -> {
            boolean hasModifier;
            boolean needsModifier;
            ToolStack tool = ToolStack.copyFrom(stack);
            StatOverrideModifier stats = (StatOverrideModifier)TinkerModifiers.statOverride.get();
            if (type == Type.BONUS) {
                needsModifier = op == Operation.MODIFY ? stats.addBonus(tool, stat, value) : stats.setBonus(tool, stat, value);
            } else {
                FloatToolStat floatStat = (FloatToolStat)stat;
                needsModifier = op == Operation.MODIFY ? stats.multiply(tool, floatStat, value) : stats.setMultiplier(tool, floatStat, value);
            }
            int level = tool.getUpgrades().getLevel(stats);
            boolean bl = hasModifier = level > 0;
            if (needsModifier && !hasModifier) {
                tool.addModifier(stats, 1);
            } else if (hasModifier && !needsModifier) {
                tool.removeModifier(stats, level);
            } else {
                tool.rebuildStats();
            }
            ValidatedResult validated = tool.validate();
            if (validated.hasError()) {
                throw MODIFIER_ERROR.create((Object)validated.getMessage());
            }
            living.func_184611_a(Hand.MAIN_HAND, tool.createStack());
            return true;
        });
        CommandSource source = (CommandSource)context.getSource();
        int size = successes.size();
        String successKey = SUCCESS_KEY_PREFIX + type.key + "." + op.key + ".";
        if (size == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(successKey + "single", new Object[]{stat.getPrefix(), Float.valueOf(value), successes.get(0).func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(successKey + "multiple", new Object[]{stat.getPrefix(), Float.valueOf(value), size}), true);
        }
        return size;
    }

    private static int resetStat(CommandContext<CommandSource> context) throws CommandSyntaxException {
        IToolStat<?> stat = ToolStatArgument.getStat(context, "stat_type");
        List<LivingEntity> successes = HeldModifiableItemIterator.apply(context, (living, stack) -> {
            StatOverrideModifier stats;
            ToolStack tool = ToolStack.from(stack);
            int currentLevel = tool.getModifierLevel(stats = (StatOverrideModifier)TinkerModifiers.statOverride.get());
            if (currentLevel > 0) {
                boolean needsModifier;
                tool = tool.copy();
                if (stat instanceof FloatToolStat) {
                    stats.setMultiplier(tool, (FloatToolStat)stat, 1.0f);
                }
                if (!(needsModifier = stats.setBonus(tool, stat, 0.0f))) {
                    tool.removeModifier(stats, currentLevel);
                } else {
                    tool.rebuildStats();
                }
                ValidatedResult validated = tool.validate();
                if (validated.hasError()) {
                    throw MODIFIER_ERROR.create((Object)validated.getMessage());
                }
                living.func_184611_a(Hand.MAIN_HAND, tool.createStack());
            }
            return true;
        });
        CommandSource source = (CommandSource)context.getSource();
        int size = successes.size();
        if (size == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(RESET_STAT_SINGLE, new Object[]{stat.getPrefix(), successes.get(0).func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(RESET_STAT_MULTIPLE, new Object[]{stat.getPrefix(), size}), true);
        }
        return size;
    }

    private static int resetAll(CommandContext<CommandSource> context) throws CommandSyntaxException {
        List<LivingEntity> successes = HeldModifiableItemIterator.apply(context, (living, stack) -> {
            StatOverrideModifier stats;
            ToolStack tool = ToolStack.from(stack);
            int level = tool.getModifierLevel(stats = (StatOverrideModifier)TinkerModifiers.statOverride.get());
            if (level > 0) {
                tool = tool.copy();
                tool.removeModifier(stats, level);
                stats.onRemoved(tool);
                ValidatedResult validated = tool.validate();
                if (validated.hasError()) {
                    throw MODIFIER_ERROR.create((Object)validated.getMessage());
                }
                living.func_184611_a(Hand.MAIN_HAND, tool.createStack());
            }
            return true;
        });
        CommandSource source = (CommandSource)context.getSource();
        int size = successes.size();
        if (size == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(RESET_ALL_SINGLE, new Object[]{successes.get(0).func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent(RESET_ALL_MULTIPLE, new Object[]{size}), true);
        }
        return size;
    }

    private static enum Operation {
        MODIFY,
        SET;

        private final String key = this.name().toLowerCase(Locale.US);
    }

    private static enum Type {
        BONUS("stat_type"),
        MULTIPLY("float_stat");

        private final String key = this.name().toLowerCase(Locale.US);
        private final String stat;

        private Type(String stat) {
            this.stat = stat;
        }
    }
}

