/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import com.google.gson.JsonDeserializer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.book.TinkerBook;
import slimeknights.tconstruct.library.client.data.spritetransformer.GreyToColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.GreyToSpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.IColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.RecolorSpriteTransformer;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.data.ResourceValidator;
import slimeknights.tconstruct.library.utils.DomainDisplayName;
import slimeknights.tconstruct.library.utils.HarvestLevels;
import slimeknights.tconstruct.smeltery.SmelteryClientEvents;
import slimeknights.tconstruct.tables.TableClientEvents;
import slimeknights.tconstruct.tools.ToolClientEvents;
import slimeknights.tconstruct.world.WorldClientEvents;

public class TinkerClient {
    public static final ResourceValidator textureValidator = new ResourceValidator("textures/item/tool", "textures", ".png");

    public static void onConstruct() {
        IResourceManager manager;
        TinkerBook.initBook();
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft != null && (manager = Minecraft.func_71410_x().func_195551_G()) instanceof IReloadableResourceManager) {
            TinkerClient.addResourceListeners((IReloadableResourceManager)manager);
        }
        Consumer<RecipesUpdatedEvent> recipesUpdated = event -> RecipeCacheInvalidator.reload(true);
        MinecraftForge.EVENT_BUS.addListener(recipesUpdated);
        ISpriteTransformer.SERIALIZER.registerDeserializer(RecolorSpriteTransformer.NAME, (JsonDeserializer)RecolorSpriteTransformer.DESERIALIZER);
        GreyToSpriteTransformer.init();
        IColorMapping.SERIALIZER.registerDeserializer(GreyToColorMapping.NAME, (JsonDeserializer)GreyToColorMapping.DESERIALIZER);
    }

    private static void addResourceListeners(IReloadableResourceManager manager) {
        WorldClientEvents.addResourceListener(manager);
        TableClientEvents.addResourceListener(manager);
        SmelteryClientEvents.addResourceListener(manager);
        MaterialRenderInfoLoader.addResourceListener(manager);
        DomainDisplayName.addResourceListener(manager);
        manager.func_219534_a((IFutureReloadListener)textureValidator);
        manager.func_219534_a((IFutureReloadListener)HarvestLevels.INSTANCE);
        ToolClientEvents.addResourceListener(manager);
    }
}

