/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ForgeI18n;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.FluidTooltipHandler;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.plugin.jei.JEIPlugin;
import slimeknights.tconstruct.plugin.jei.TConstructRecipeCategoryUid;
import slimeknights.tconstruct.plugin.jei.entity.EntityIngredientHelper;
import slimeknights.tconstruct.plugin.jei.entity.EntityIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;

public class EntityMeltingRecipeCategory
implements IRecipeCategory<EntityMeltingRecipe> {
    public static final ResourceLocation BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/melting.png");
    private static final String KEY_TITLE = TConstruct.makeTranslationKey("jei", "entity_melting.title");
    private static final String KEY_PER_HEARTS = TConstruct.makeTranslationKey("jei", "entity_melting.per_hearts");
    private static final ITextComponent TOOLTIP_PER_HEART = new TranslationTextComponent(TConstruct.makeTranslationKey("jei", "entity_melting.per_heart")).func_240699_a_(TextFormatting.GRAY);
    private static final Int2ObjectMap<ITooltipCallback<FluidStack>> TOOLTIP_MAP = new Int2ObjectOpenHashMap();
    private final EntityIngredientRenderer entityRenderer = new EntityIngredientRenderer(32);
    private final IDrawable background;
    private final IDrawable icon;
    private final String title = ForgeI18n.getPattern((String)KEY_TITLE);
    private final IDrawable arrow;
    private final IDrawable tank;

    public EntityMeltingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 41, 150, 62);
        this.icon = helper.createDrawable(BACKGROUND_LOC, 174, 41, 16, 16);
        this.arrow = helper.drawableBuilder(BACKGROUND_LOC, 150, 41, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tank = helper.createDrawable(BACKGROUND_LOC, 150, 74, 16, 16);
    }

    public ResourceLocation getUid() {
        return TConstructRecipeCategoryUid.entityMelting;
    }

    public Class<? extends EntityMeltingRecipe> getRecipeClass() {
        return EntityMeltingRecipe.class;
    }

    public static List<List<ItemStack>> getSpawnEggs(Stream<EntityType<?>> entities) {
        return ImmutableList.of(entities.map(SpawnEggItem::func_200889_b).filter(Objects::nonNull).map(ItemStack::new).collect(Collectors.toList()));
    }

    public void setIngredients(EntityMeltingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(JEIPlugin.ENTITY_TYPE, recipe.getDisplayInputs());
        ingredients.setInputLists(VanillaTypes.ITEM, EntityMeltingRecipeCategory.getSpawnEggs(recipe.getInputs().stream()));
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getOutput());
    }

    public void draw(EntityMeltingRecipe recipe, MatrixStack matrices, double mouseX, double mouseY) {
        this.arrow.draw(matrices, 71, 21);
        String damage = Float.toString((float)recipe.getDamage() / 2.0f);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int x = 84 - fontRenderer.func_78256_a(damage);
        fontRenderer.func_238421_b_(matrices, damage, (float)x, 8.0f, Color.RED.getRGB());
    }

    public void setRecipe(IRecipeLayout layout, EntityMeltingRecipe recipe, IIngredients ingredients) {
        IGuiIngredientGroup entityTypes = layout.getIngredientsGroup(JEIPlugin.ENTITY_TYPE);
        entityTypes.init(0, true, (IIngredientRenderer)this.entityRenderer, 19, 11, 32, 32, 0, 0);
        entityTypes.set(ingredients);
        EntityIngredientHelper.setFocus(layout, (IGuiIngredientGroup<EntityType>)entityTypes, recipe.getInputs(), 0);
        IGuiFluidStackGroup fluids = layout.getFluidStacks();
        fluids.addTooltipCallback((ITooltipCallback)TOOLTIP_MAP.computeIfAbsent(recipe.getDamage(), FluidTooltip::new));
        fluids.init(1, false, 115, 11, 16, 32, 144, false, null);
        fluids.set(ingredients);
        fluids.init(2, true, 75, 43, 16, 16, 1, false, this.tank);
        fluids.set(2, MeltingFuelHandler.getUsableFuels(1));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }

    private static class FluidTooltip
    implements ITooltipCallback<FluidStack> {
        private final int damage;

        public void onTooltip(int index, boolean input, FluidStack fluid, List<ITextComponent> list) {
            ITextComponent name = list.get(0);
            ITextComponent modId = list.get(list.size() - 1);
            list.clear();
            list.add(name);
            if (index != 2) {
                FluidTooltipHandler.appendMaterial(fluid, list);
            }
            if (index == 1) {
                if (this.damage == 2) {
                    list.add(TOOLTIP_PER_HEART);
                } else {
                    list.add((ITextComponent)new TranslationTextComponent(KEY_PER_HEARTS, new Object[]{Float.valueOf((float)this.damage / 2.0f)}).func_240699_a_(TextFormatting.GRAY));
                }
            }
            list.add(modId);
        }

        public FluidTooltip(int damage) {
            this.damage = damage;
        }
    }
}

