/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.tables.TinkerTables;

public class ItemPartRecipeBuilder
extends AbstractRecipeBuilder<ItemPartRecipeBuilder> {
    private final MaterialId materialId;
    private final ResourceLocation pattern;
    private final int cost;
    private final ItemOutput result;

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, Objects.requireNonNull(this.result.get().func_77973_b().getRegistryName()));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "parts");
        consumer.accept((IFinishedRecipe)new FinishedRecipe(id, advancementId));
    }

    private ItemPartRecipeBuilder(MaterialId materialId, ResourceLocation pattern, int cost, ItemOutput result) {
        this.materialId = materialId;
        this.pattern = pattern;
        this.cost = cost;
        this.result = result;
    }

    public static ItemPartRecipeBuilder item(MaterialId materialId, ResourceLocation pattern, int cost, ItemOutput result) {
        return new ItemPartRecipeBuilder(materialId, pattern, cost, result);
    }

    private class FinishedRecipe
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public FinishedRecipe(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)ItemPartRecipeBuilder.this, ID, advancementID);
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("material", ItemPartRecipeBuilder.this.materialId.toString());
            json.addProperty("pattern", ItemPartRecipeBuilder.this.pattern.toString());
            json.addProperty("cost", (Number)ItemPartRecipeBuilder.this.cost);
            json.add("result", ItemPartRecipeBuilder.this.result.serialize());
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)TinkerTables.itemPartBuilderSerializer.get();
        }
    }
}

