/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.salvage;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.recipe.RandomItem;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.salvage.AbstractModifierSalvage;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierSalvage
extends AbstractModifierSalvage {
    private final List<RandomItem> result;

    public ModifierSalvage(ResourceLocation id, Ingredient toolIngredient, Modifier modifier, int minLevel, int maxLevel, List<RandomItem> result, @Nullable SlotType.SlotCount slots) {
        super(id, toolIngredient, modifier, minLevel, maxLevel, slots);
        this.result = result;
        ModifierRecipeLookup.addSalvage(this);
    }

    @Override
    public void acceptItems(IModifierToolStack tool, Consumer<ItemStack> stackConsumer, Random random) {
        for (RandomItem randomItem : this.result) {
            ItemStack stack = randomItem.get(random);
            if (stack.func_190926_b()) continue;
            stackConsumer.accept(stack);
        }
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerModifiers.modifierSalvageSerializer.get();
    }

    public static class Serializer
    extends AbstractModifierSalvage.AbstractSerializer<ModifierSalvage> {
        @Override
        protected ModifierSalvage read(ResourceLocation id, JsonObject json, Ingredient toolIngredient, Modifier modifier, int minLevel, int maxLevel, @Nullable SlotType.SlotCount slots) {
            Object result = ImmutableList.of();
            if (json.has("salvage")) {
                result = JsonHelper.parseList((JsonObject)json, (String)"salvage", RandomItem::fromJson);
            }
            return new ModifierSalvage(id, toolIngredient, modifier, minLevel, maxLevel, (List<RandomItem>)result, slots);
        }

        @Override
        protected ModifierSalvage read(ResourceLocation id, PacketBuffer buffer, Ingredient toolIngredient, Modifier modifier, int minLevel, int maxLevel, @Nullable SlotType.SlotCount slots) {
            ImmutableList.Builder result = ImmutableList.builder();
            int count = buffer.func_150792_a();
            for (int i = 0; i < count; ++i) {
                result.add((Object)RandomItem.read(buffer));
            }
            return new ModifierSalvage(id, toolIngredient, modifier, minLevel, maxLevel, (List<RandomItem>)result.build(), slots);
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, ModifierSalvage recipe) {
            super.writeSafe(buffer, recipe);
            buffer.func_150787_b(recipe.result.size());
            for (RandomItem randomItem : recipe.result) {
                randomItem.write(buffer);
            }
        }
    }
}

