/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SwappableModifierRecipe
extends ModifierRecipe {
    private final String value;

    public SwappableModifierRecipe(ResourceLocation id, List<SizedIngredient> inputs, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, Modifier result, String value, @Nullable SlotType.SlotCount slots) {
        super(id, inputs, toolRequirement, requirements, requirementsError, new ModifierEntry(result, 1), 1, slots);
        this.value = value;
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationInventory inv) {
        SlotType.SlotCount slots;
        ValidatedResult commonError;
        boolean needsModifier;
        ToolStack tool = ToolStack.from(inv.getTinkerableStack());
        Modifier modifier = this.result.getModifier();
        if (tool.getUpgrades().getLevel(modifier) == 0) {
            needsModifier = true;
            commonError = this.validatePrerequisites(tool);
        } else {
            needsModifier = false;
            commonError = this.validateRequirements(tool);
        }
        if (commonError.hasError()) {
            return commonError;
        }
        tool = tool.copy();
        ModDataNBT persistentData = tool.getPersistentData();
        if (needsModifier && (slots = this.getSlots()) != null) {
            persistentData.addSlots(slots.getType(), -slots.getCount());
        }
        persistentData.putString(modifier.getId(), this.value);
        if (needsModifier) {
            tool.addModifier(this.result.getModifier(), 1);
        } else {
            tool.rebuildStats();
        }
        ValidatedResult toolValidation = tool.validate();
        if (toolValidation.hasError()) {
            return toolValidation;
        }
        return ValidatedResult.success(tool.createStack());
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerModifiers.swappableModifierSerializer.get();
    }

    @Override
    public List<ItemStack> getToolWithModifier() {
        if (this.toolWithModifier == null) {
            ModifierId id = this.result.getModifier().getId();
            this.toolWithModifier = this.getToolInputs().stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, this.requirements, this.result, data -> data.putString(id, this.value))).collect(Collectors.toList());
        }
        return this.toolWithModifier;
    }

    public static class Serializer
    extends AbstractModifierRecipe.Serializer<SwappableModifierRecipe> {
        @Override
        protected ModifierEntry readResult(JsonObject json) {
            JsonObject result = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
            return new ModifierEntry(ModifierEntry.deserializeModifier(result, "name"), 1);
        }

        @Override
        public SwappableModifierRecipe read(ResourceLocation id, JsonObject json, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, int upgradeSlots, int abilitySlots) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SwappableModifierRecipe read(ResourceLocation id, PacketBuffer buffer, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, int upgradeSlots, int abilitySlots) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SwappableModifierRecipe read(ResourceLocation id, JsonObject json, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            List ingredients = JsonHelper.parseList((JsonObject)json, (String)"inputs", SizedIngredient::deserialize);
            String value = JSONUtils.func_151200_h((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (String)"value");
            return new SwappableModifierRecipe(id, (List<SizedIngredient>)ingredients, toolRequirement, requirements, requirementsError, result.getModifier(), value, slots);
        }

        @Override
        public SwappableModifierRecipe read(ResourceLocation id, PacketBuffer buffer, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            int size = buffer.func_150792_a();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                builder.add((Object)SizedIngredient.read((PacketBuffer)buffer));
            }
            String value = buffer.func_218666_n();
            return new SwappableModifierRecipe(id, (List<SizedIngredient>)builder.build(), toolRequirement, requirements, requirementsError, result.getModifier(), value, slots);
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, SwappableModifierRecipe recipe) {
            super.writeSafe(buffer, recipe);
            buffer.func_150787_b(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
            buffer.func_180714_a(recipe.value);
        }
    }
}

