/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.materials;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;

public class MaterialRenderInfo {
    private final MaterialId identifier;
    @Nullable
    private final ResourceLocation texture;
    private final String[] fallbacks;
    private final int vertexColor;
    private final int luminosity;

    @Nullable
    private TextureAtlasSprite trySprite(RenderMaterial base, String suffix, Function<RenderMaterial, TextureAtlasSprite> spriteGetter) {
        TextureAtlasSprite sprite = spriteGetter.apply(MaterialRenderInfo.getMaterial(base.func_229313_b_(), suffix));
        if (!MissingTextureSprite.func_195675_b().equals((Object)sprite.func_195668_m())) {
            return sprite;
        }
        return null;
    }

    public TintedSprite getSprite(RenderMaterial base, Function<RenderMaterial, TextureAtlasSprite> spriteGetter) {
        TextureAtlasSprite sprite;
        if (this.texture != null && (sprite = this.trySprite(base, MaterialRenderInfo.getSuffix(this.texture), spriteGetter)) != null) {
            return TintedSprite.of(sprite, -1);
        }
        for (String fallback : this.fallbacks) {
            sprite = this.trySprite(base, fallback, spriteGetter);
            if (sprite == null) continue;
            return TintedSprite.of(sprite, this.vertexColor);
        }
        return TintedSprite.of(spriteGetter.apply(base), this.vertexColor);
    }

    public void getTextureDependencies(Predicate<RenderMaterial> textures, RenderMaterial base) {
        if (this.texture != null) {
            textures.test(MaterialRenderInfo.getMaterial(base.func_229313_b_(), MaterialRenderInfo.getSuffix(this.texture)));
        }
        for (String fallback : this.fallbacks) {
            textures.test(MaterialRenderInfo.getMaterial(base.func_229313_b_(), fallback));
        }
    }

    public static String getSuffix(ResourceLocation material) {
        if ("minecraft".equals(material.func_110624_b())) {
            return material.func_110623_a();
        }
        return material.func_110624_b() + "_" + material.func_110623_a();
    }

    private static RenderMaterial getMaterial(ResourceLocation texture, String suffix) {
        return ModelLoaderRegistry.blockMaterial((ResourceLocation)new ResourceLocation(texture.func_110624_b(), texture.func_110623_a() + "_" + suffix));
    }

    public MaterialRenderInfo(MaterialId identifier, @Nullable ResourceLocation texture, String[] fallbacks, int vertexColor, int luminosity) {
        this.identifier = identifier;
        this.texture = texture;
        this.fallbacks = fallbacks;
        this.vertexColor = vertexColor;
        this.luminosity = luminosity;
    }

    public MaterialId getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public ResourceLocation getTexture() {
        return this.texture;
    }

    public String[] getFallbacks() {
        return this.fallbacks;
    }

    public int getVertexColor() {
        return this.vertexColor;
    }

    public int getLuminosity() {
        return this.luminosity;
    }

    public static class TintedSprite {
        private final TextureAtlasSprite sprite;
        private final int color;

        private TintedSprite(TextureAtlasSprite sprite, int color) {
            this.sprite = sprite;
            this.color = color;
        }

        public static TintedSprite of(TextureAtlasSprite sprite, int color) {
            return new TintedSprite(sprite, color);
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        public int getColor() {
            return this.color;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TintedSprite)) {
                return false;
            }
            TintedSprite other = (TintedSprite)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TextureAtlasSprite this$sprite = this.getSprite();
            TextureAtlasSprite other$sprite = other.getSprite();
            if (this$sprite == null ? other$sprite != null : !this$sprite.equals(other$sprite)) {
                return false;
            }
            return this.getColor() == other.getColor();
        }

        protected boolean canEqual(Object other) {
            return other instanceof TintedSprite;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TextureAtlasSprite $sprite = this.getSprite();
            result = result * 59 + ($sprite == null ? 43 : $sprite.hashCode());
            result = result * 59 + this.getColor();
            return result;
        }

        public String toString() {
            return "MaterialRenderInfo.TintedSprite(sprite=" + this.getSprite() + ", color=" + this.getColor() + ")";
        }
    }
}

