/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.tileentity;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mods.waterstrainer.WaterStrainer;
import mods.waterstrainer.inventory.ContainerWormBin;
import mods.waterstrainer.registry.ItemRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TileEntityWormBin
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public InventoryHandler inv = this.initInventory();
    private int curWormProg = 0;
    private int curFertProg = 0;
    public static final int MAX_WORM_PROG = 4;
    public static final int MAX_FERT_PROG = 20;
    public static final List<Item> FOODS = Arrays.asList(Items.field_151174_bG, Items.field_203180_bP, Items.field_185164_cV, Items.field_151127_ba, Items.field_222112_pR, Items.field_151172_bF, Items.field_151034_e, Items.field_185161_cS);
    private final IIntArray syncValues = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TileEntityWormBin.this.curWormProg;
                }
                case 1: {
                    return TileEntityWormBin.this.curFertProg;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityWormBin.this.curWormProg = value;
                    break;
                }
                case 1: {
                    TileEntityWormBin.this.curFertProg = value;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };
    private final LazyOptional<IItemHandler> capItemHandler = LazyOptional.of(() -> this.createCapabilityHandler());

    public TileEntityWormBin() {
        super(WaterStrainer.tile_worm_bin);
    }

    private InventoryHandler initInventory() {
        return new InventoryHandler(this);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inv = this.initInventory();
        this.inv.deserializeNBT(nbt);
        this.curWormProg = nbt.func_74762_e("CurWormProg");
        this.curFertProg = nbt.func_74762_e("CurFertProg");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_197643_a(this.inv.serializeNBT());
        nbt.func_74768_a("CurWormProg", this.curWormProg);
        nbt.func_74768_a("CurFertProg", this.curFertProg);
        return nbt;
    }

    protected IItemHandler createCapabilityHandler() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inv}){

            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return slot == 0 && this.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return slot == 1 || slot == 2 ? super.extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
            }
        };
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.capItemHandler);
    }

    public static boolean isItemValidFood(ItemStack stack) {
        return FOODS.contains(stack.func_77973_b()) && stack.func_77973_b().func_219971_r();
    }

    public ItemStack getFood() {
        return this.inv.getStackInSlot(0);
    }

    public ItemStack getWorm() {
        return this.inv.getStackInSlot(1);
    }

    public ItemStack getFertilizer() {
        return this.inv.getStackInSlot(2);
    }

    public void func_73660_a() {
        ItemStack foodStack;
        if (!this.field_145850_b.field_72995_K && !(foodStack = this.getFood()).func_190926_b() && foodStack.func_222117_E()) {
            ItemStack wormStack = this.getWorm();
            ItemStack fertStack = this.getFertilizer();
            if (wormStack.func_190916_E() < wormStack.func_77976_d() && fertStack.func_190916_E() < fertStack.func_77976_d()) {
                int stacksize;
                Food food = foodStack.func_77973_b().func_219967_s();
                this.curWormProg += food.func_221466_a();
                this.curFertProg += food.func_221466_a();
                if (this.curWormProg >= 4) {
                    stacksize = Math.min(wormStack.func_77976_d(), wormStack.func_190916_E() + this.curWormProg / 4);
                    if (!wormStack.func_190926_b()) {
                        wormStack.func_190920_e(stacksize);
                    } else {
                        this.inv.setStackInSlot(1, new ItemStack((IItemProvider)ItemRegistry.worm, stacksize));
                    }
                    this.curWormProg %= 4;
                }
                if (this.curFertProg >= 20) {
                    stacksize = Math.min(fertStack.func_77976_d(), fertStack.func_190916_E() + this.curFertProg / 20);
                    if (!fertStack.func_190926_b()) {
                        fertStack.func_190920_e(stacksize);
                    } else {
                        this.inv.setStackInSlot(2, new ItemStack((IItemProvider)ItemRegistry.fertilizer, stacksize));
                    }
                    this.curFertProg %= 20;
                }
                foodStack.func_190918_g(1);
                this.func_70296_d();
            }
        }
    }

    public Container createMenu(int id, PlayerInventory invIn, PlayerEntity playerIn) {
        return new ContainerWormBin(id, invIn, this.func_174877_v(), this.syncValues);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.waterstrainer.worm_bin");
    }

    public class InventoryHandler
    extends ItemStackHandler {
        private final TileEntityWormBin tile;

        private InventoryHandler(TileEntityWormBin te) {
            super(3);
            this.tile = te;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.tile.func_70296_d();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 0) {
                return TileEntityWormBin.isItemValidFood(stack);
            }
            return true;
        }
    }
}

