/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.hands;

import artifacts.common.capability.killtracker.EntityKillTrackerCapability;
import artifacts.common.config.ModConfig;
import artifacts.common.item.curio.CurioItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;

public class GoldenHookItem
extends CurioItem {
    public GoldenHookItem() {
        this.addListener(LivingExperienceDropEvent.class, this::onLivingExperienceDrop, LivingExperienceDropEvent::getAttackingPlayer);
    }

    private void onLivingExperienceDrop(LivingExperienceDropEvent event, LivingEntity wearer) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            return;
        }
        double killRatio = wearer.getCapability(EntityKillTrackerCapability.INSTANCE).map(tracker -> tracker.getKillRatio(event.getEntityLiving().func_200600_R())).orElse(0.0);
        double minMultiplier = (Double)ModConfig.server.goldenHook.minExperienceMultiplier.get();
        double maxMultiplier = (Double)ModConfig.server.goldenHook.maxExperienceMultiplier.get();
        double maxKillRatio = (Double)ModConfig.server.goldenHook.maximumKillRatio.get();
        double maxExperience = ((Integer)ModConfig.server.goldenHook.maxExperience.get()).intValue();
        double multiplier = MathHelper.func_219803_d((double)Math.max(0.0, (maxKillRatio - killRatio) / maxKillRatio), (double)minMultiplier, (double)maxMultiplier);
        int experienceBonus = (int)Math.min(maxExperience, multiplier * (double)event.getOriginalExperience());
        event.setDroppedExperience(event.getDroppedExperience() + experienceBonus);
        this.damageEquippedStacks(wearer);
    }
}

