/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.hands;

import artifacts.common.config.ModConfig;
import artifacts.common.item.curio.CurioItem;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class DiggingClawsItem
extends CurioItem {
    public DiggingClawsItem() {
        this.addListener(EventPriority.LOW, PlayerEvent.BreakSpeed.class, this::onBreakSpeed);
        this.addListener(PlayerEvent.HarvestCheck.class, this::onHarvestCheck);
    }

    private boolean canHarvest(BlockState state) {
        List toolTypes = (List)ModConfig.server.diggingClaws.toolTypes.get();
        int diggingClawsHarvestLevel = (Integer)ModConfig.server.diggingClaws.harvestLevel.get() - 1;
        return state.getHarvestLevel() <= diggingClawsHarvestLevel && (state.getHarvestTool() == null || toolTypes.contains(state.getHarvestTool().getName()) || toolTypes.contains("*"));
    }

    private void onBreakSpeed(PlayerEvent.BreakSpeed event, LivingEntity wearer) {
        if (this.canHarvest(event.getState())) {
            event.setNewSpeed((float)((double)event.getNewSpeed() + (Double)ModConfig.server.diggingClaws.miningSpeedBonus.get()));
        }
    }

    private void onHarvestCheck(PlayerEvent.HarvestCheck event, LivingEntity wearer) {
        if (!event.canHarvest()) {
            int diggingClawsHarvestLevel = (Integer)ModConfig.server.diggingClaws.harvestLevel.get() - 1;
            event.setCanHarvest(event.getTargetBlock().getHarvestLevel() <= diggingClawsHarvestLevel);
            this.damageEquippedStacks(wearer);
        }
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.field_232681_Q_, 1.0f, 1.0f);
    }
}

