/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.feet;

import artifacts.common.config.ModConfig;
import artifacts.common.item.curio.CurioItem;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;

public class RunningShoesItem
extends CurioItem {
    public RunningShoesItem() {
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerTick);
    }

    private static AttributeModifier getSpeedBonus() {
        double speedMultiplier = (Double)ModConfig.server.runningShoes.speedMultiplier.get();
        return new AttributeModifier(UUID.fromString("ac7ab816-2b08-46b6-879d-e5dea34ff305"), "artifacts:running_shoes_movement_speed", speedMultiplier, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    private void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!this.isEquippedBy((LivingEntity)event.player)) {
            ModifiableAttributeInstance movementSpeed = event.player.func_110148_a(Attributes.field_233821_d_);
            AttributeModifier speedBonus = RunningShoesItem.getSpeedBonus();
            if (movementSpeed != null && movementSpeed.func_180374_a(speedBonus)) {
                movementSpeed.func_111124_b(speedBonus);
                event.player.field_70138_W = 0.6f;
            }
        }
    }

    public void curioTick(String identifier, int index, LivingEntity entity, ItemStack stack) {
        if (!ModConfig.server.isCosmetic(this)) {
            ModifiableAttributeInstance movementSpeed = entity.func_110148_a(Attributes.field_233821_d_);
            AttributeModifier speedBonus = RunningShoesItem.getSpeedBonus();
            if (entity.func_70051_ag()) {
                if (!movementSpeed.func_180374_a(speedBonus)) {
                    movementSpeed.func_233767_b_(speedBonus);
                }
                if (entity instanceof PlayerEntity) {
                    entity.field_70138_W = Math.max(entity.field_70138_W, 1.1f);
                }
                if (entity.field_70173_aa % 20 == 0) {
                    this.damageStack(identifier, index, entity, stack);
                }
            } else if (movementSpeed.func_180374_a(speedBonus)) {
                movementSpeed.func_111124_b(speedBonus);
                entity.field_70138_W = 0.6f;
            }
        }
    }
}

