/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.feet;

import artifacts.common.capability.swimhandler.ISwimHandler;
import artifacts.common.capability.swimhandler.SwimHandlerCapability;
import artifacts.common.item.curio.CurioItem;
import be.florens.expandability.api.forge.LivingFluidCollisionEvent;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.eventbus.api.Event;

public class AquaDashersItem
extends CurioItem {
    public AquaDashersItem() {
        this.addListener(LivingFluidCollisionEvent.class, this::onFluidCollision);
    }

    private void onFluidCollision(LivingFluidCollisionEvent event, LivingEntity wearer) {
        if (wearer.func_70051_ag() && wearer.field_70143_R < 6.0f && !wearer.func_184587_cr() && !wearer.func_213453_ef()) {
            wearer.getCapability(SwimHandlerCapability.INSTANCE).ifPresent(handler -> {
                if (!handler.isWet() && !handler.isSwimming()) {
                    event.setResult(Event.Result.ALLOW);
                    if (event.getFluidState().func_206884_a((ITag)FluidTags.field_206960_b) && !wearer.func_230279_az_() && !EnchantmentHelper.func_189869_j((LivingEntity)wearer)) {
                        wearer.func_70097_a(DamageSource.field_190095_e, 1.0f);
                    }
                }
            });
        }
    }

    public void curioTick(String identifier, int index, LivingEntity entity, ItemStack stack) {
        if (entity.field_70173_aa % 20 == 0 && this.isSprintingOnFluid(entity)) {
            this.damageStack(identifier, index, entity, stack);
        }
    }

    public boolean isSprinting(LivingEntity entity) {
        return this.isEquippedBy(entity) && entity.func_70051_ag() && entity.field_70143_R < 6.0f && entity.getCapability(SwimHandlerCapability.INSTANCE).map(ISwimHandler::isWet).orElse(true) == false;
    }

    private boolean isSprintingOnFluid(LivingEntity entity) {
        if (this.isSprinting(entity)) {
            BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)entity.func_226277_ct_()), MathHelper.func_76128_c((double)(entity.func_226278_cu_() - 0.2)), MathHelper.func_76128_c((double)entity.func_226281_cx_()));
            return !entity.field_70170_p.func_180495_p(pos).func_204520_s().func_206888_e();
        }
        return false;
    }
}

