/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio;

import artifacts.client.render.curio.CurioRenderers;
import artifacts.common.config.ModConfig;
import artifacts.common.item.ArtifactItem;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CurioItem
extends ArtifactItem
implements ICurioItem {
    public boolean isEquippedBy(@Nullable LivingEntity entity) {
        return !ModConfig.server.isCosmetic(this) && entity != null && CuriosApi.getCuriosHelper().findEquippedCurio((Item)this, entity).isPresent();
    }

    protected <T extends Event, S extends LivingEntity> void addListener(EventPriority priority, Class<T> eventClass, BiConsumer<T, S> listener, Function<T, S> wearerSupplier) {
        MinecraftForge.EVENT_BUS.addListener(priority, true, eventClass, event -> {
            LivingEntity wearer = (LivingEntity)wearerSupplier.apply(event);
            if (this.isEquippedBy(wearer)) {
                listener.accept(event, wearer);
            }
        });
    }

    protected <T extends Event, S extends LivingEntity> void addListener(Class<T> eventClass, BiConsumer<T, S> listener, Function<T, S> wearerSupplier) {
        this.addListener(EventPriority.NORMAL, eventClass, listener, wearerSupplier);
    }

    protected <T extends LivingEvent> void addListener(EventPriority priority, Class<T> eventClass, BiConsumer<T, LivingEntity> listener) {
        this.addListener(priority, eventClass, listener, LivingEvent::getEntityLiving);
    }

    protected <T extends LivingEvent> void addListener(Class<T> eventClass, BiConsumer<T, LivingEntity> listener) {
        this.addListener(EventPriority.NORMAL, eventClass, listener);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.RARE;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return CurioRenderers.getRenderer(this) != null;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ticks, float headYaw, float headPitch, ItemStack stack) {
        CurioRenderers.getRenderer(this).render(identifier, index, matrixStack, buffer, light, entity, limbSwing, limbSwingAmount, partialTicks, ticks, headYaw, headPitch, stack);
    }

    protected void damageStack(String identifier, int index, LivingEntity entity, ItemStack stack) {
        this.damageStack(identifier, index, entity, stack, 1);
    }

    protected void damageStack(String identifier, int index, LivingEntity entity, ItemStack stack, int damage) {
        stack.func_222118_a(damage, entity, damager -> CuriosApi.getCuriosHelper().onBrokenCurio(identifier, index, damager));
    }

    protected void damageEquippedStacks(LivingEntity entity, int damage) {
        CuriosApi.getCuriosHelper().getCuriosHandler(entity).ifPresent(curiosHandler -> curiosHandler.getCurios().forEach((identifier, stacksHandler) -> {
            IDynamicStackHandler stacks = stacksHandler.getStacks();
            for (int slot = 0; slot < stacks.getSlots(); ++slot) {
                ItemStack stack = stacks.getStackInSlot(slot);
                if (stack.func_190926_b() || stack.func_77973_b() != this) continue;
                this.damageStack((String)identifier, slot, entity, stack, damage);
            }
        }));
    }

    public void damageEquippedStacks(LivingEntity entity) {
        this.damageEquippedStacks(entity, 1);
    }
}

