/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.render.entity;

import artifacts.client.render.entity.model.MimicChestLayerModel;
import artifacts.client.render.entity.model.MimicModel;
import artifacts.common.config.ModConfig;
import artifacts.common.entity.MimicEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.state.properties.ChestType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.ModList;

public class MimicChestLayer
extends LayerRenderer<MimicEntity, MimicModel> {
    private final MimicChestLayerModel chestModel;
    public final RenderMaterial vanillaChestMaterial;
    public final List<RenderMaterial> chestMaterials;

    public MimicChestLayer(IEntityRenderer<MimicEntity, MimicModel> entityRenderer) {
        super(entityRenderer);
        Calendar calendar = Calendar.getInstance();
        boolean isChristmas = calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
        this.chestModel = new MimicChestLayerModel();
        this.chestMaterials = new ArrayList<RenderMaterial>();
        this.vanillaChestMaterial = Atlases.func_228771_a_(null, (ChestType)ChestType.SINGLE, (boolean)isChristmas);
        if (ModList.get().isLoaded("lootr")) {
            ResourceLocation chestLocation = new ResourceLocation("lootr", "chest");
            this.chestMaterials.add(new RenderMaterial(AtlasTexture.field_110575_b, chestLocation));
        } else {
            if (!isChristmas && ModList.get().isLoaded("quark")) {
                List<String> chestTypes = Arrays.asList("oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "warped", "crimson");
                ResourceLocation atlas = new ResourceLocation("textures/atlas/chest.png");
                for (String chestType : chestTypes) {
                    ResourceLocation chestLocation = new ResourceLocation("quark", String.format("model/chest/%s/normal", chestType));
                    this.chestMaterials.add(new RenderMaterial(atlas, chestLocation));
                }
            }
            this.chestMaterials.add(this.vanillaChestMaterial);
        }
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, MimicEntity mimic, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!mimic.func_82150_aj()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            matrixStack.func_227861_a_(-0.5, -1.5, -0.5);
            ((MimicModel)this.func_215332_c()).func_217111_a(this.chestModel);
            this.chestModel.prepareMobModel(mimic, limbSwing, limbSwingAmount, partialTicks);
            this.chestModel.setupAnim(mimic, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            IVertexBuilder builder = this.getChestMaterial(mimic).func_229311_a_(buffer, RenderType::func_228638_b_);
            this.chestModel.func_225598_a_(matrixStack, builder, packedLight, LivingRenderer.func_229117_c_((LivingEntity)mimic, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.func_227865_b_();
        }
    }

    private RenderMaterial getChestMaterial(MimicEntity mimic) {
        if (!((Boolean)ModConfig.client.useModdedMimicTextures.get()).booleanValue()) {
            return this.vanillaChestMaterial;
        }
        if (this.chestMaterials.size() == 1) {
            return this.chestMaterials.get(0);
        }
        return this.chestMaterials.get((int)(Math.abs(mimic.func_110124_au().getMostSignificantBits()) % (long)this.chestMaterials.size()));
    }
}

