/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.render.curio.renderer;

import artifacts.client.render.curio.model.HandsModel;
import artifacts.client.render.curio.renderer.GloveCurioRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeRenderTypes;

public class GlowingGloveCurioRenderer
extends GloveCurioRenderer {
    private final ResourceLocation defaultGlowTexture;
    private final ResourceLocation slimGlowTexture;

    public GlowingGloveCurioRenderer(String name) {
        super(name);
        this.defaultGlowTexture = new ResourceLocation("artifacts", String.format("textures/entity/curio/glove/%s/%s_default_glow.png", name, name));
        this.slimGlowTexture = new ResourceLocation("artifacts", String.format("textures/entity/curio/glove/%s/%s_slim_glow.png", name, name));
    }

    private ResourceLocation getGlowTexture(boolean hasSlimArms) {
        return hasSlimArms ? this.slimGlowTexture : this.defaultGlowTexture;
    }

    @Override
    protected void renderArm(HandsModel model, MatrixStack matrixStack, IRenderTypeBuffer buffer, HandSide handSide, int light, boolean hasSlimArms, boolean hasFoil) {
        super.renderArm(model, matrixStack, buffer, handSide, light, hasSlimArms, hasFoil);
        RenderType renderType = ForgeRenderTypes.getUnlitTranslucent((ResourceLocation)this.getGlowTexture(hasSlimArms));
        IVertexBuilder builder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)renderType, (boolean)false, (boolean)hasFoil);
        model.renderHand(handSide, matrixStack, builder, LightTexture.func_228451_a_((int)15, (int)15), OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    protected void renderFirstPersonArm(HandsModel model, ModelRenderer arm, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, boolean hasSlimArms, boolean hasFoil) {
        super.renderFirstPersonArm(model, arm, matrixStack, buffer, light, hasSlimArms, hasFoil);
        IVertexBuilder builder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)ForgeRenderTypes.getUnlitTranslucent((ResourceLocation)this.getGlowTexture(hasSlimArms)), (boolean)false, (boolean)hasFoil);
        arm.func_228308_a_(matrixStack, builder, LightTexture.func_228451_a_((int)15, (int)15), OverlayTexture.field_229196_a_);
    }
}

