/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.render.curio;

import artifacts.client.render.curio.model.BeltModel;
import artifacts.client.render.curio.model.HandsModel;
import artifacts.client.render.curio.model.HeadModel;
import artifacts.client.render.curio.model.LegsModel;
import artifacts.client.render.curio.model.NecklaceModel;
import artifacts.client.render.curio.model.ScarfModel;
import artifacts.client.render.curio.renderer.BeltCurioRenderer;
import artifacts.client.render.curio.renderer.CurioRenderer;
import artifacts.client.render.curio.renderer.GloveCurioRenderer;
import artifacts.client.render.curio.renderer.GlowingCurioRenderer;
import artifacts.client.render.curio.renderer.GlowingGloveCurioRenderer;
import artifacts.client.render.curio.renderer.SimpleCurioRenderer;
import artifacts.common.init.ModItems;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CurioRenderers {
    private static final Map<Item, CurioRenderer> renderers = new HashMap<Item, CurioRenderer>();

    public static CurioRenderer getRenderer(Item curio) {
        return renderers.get(curio);
    }

    @Nullable
    public static GloveCurioRenderer getGloveRenderer(ItemStack stack) {
        CurioRenderer renderer;
        if (!stack.func_190926_b() && (renderer = CurioRenderers.getRenderer(stack.func_77973_b())) instanceof GloveCurioRenderer) {
            return (GloveCurioRenderer)renderer;
        }
        return null;
    }

    public static void setupCurioRenderers() {
        renderers.put((Item)ModItems.PLASTIC_DRINKING_HAT.get(), new SimpleCurioRenderer("drinking_hat/plastic_drinking_hat", HeadModel.drinkingHat()));
        renderers.put((Item)ModItems.NOVELTY_DRINKING_HAT.get(), new SimpleCurioRenderer("drinking_hat/novelty_drinking_hat", HeadModel.drinkingHat()));
        renderers.put((Item)ModItems.SNORKEL.get(), new SimpleCurioRenderer("snorkel", HeadModel.snorkel()));
        renderers.put((Item)ModItems.NIGHT_VISION_GOGGLES.get(), new GlowingCurioRenderer("night_vision_goggles", HeadModel.nightVisionGoggles()));
        renderers.put((Item)ModItems.SUPERSTITIOUS_HAT.get(), new SimpleCurioRenderer("superstitious_hat", HeadModel.superstitiousHat()));
        renderers.put((Item)ModItems.VILLAGER_HAT.get(), new SimpleCurioRenderer("villager_hat", HeadModel.villagerHat()));
        renderers.put((Item)ModItems.LUCKY_SCARF.get(), new SimpleCurioRenderer("scarf/lucky_scarf", (BipedModel<LivingEntity>)ScarfModel.scarf(RenderType::func_228640_c_)));
        renderers.put((Item)ModItems.SCARF_OF_INVISIBILITY.get(), new SimpleCurioRenderer("scarf/scarf_of_invisibility", (BipedModel<LivingEntity>)ScarfModel.scarf(RenderType::func_228644_e_)));
        renderers.put((Item)ModItems.CROSS_NECKLACE.get(), new SimpleCurioRenderer("cross_necklace", (BipedModel<LivingEntity>)NecklaceModel.crossNecklace()));
        renderers.put((Item)ModItems.PANIC_NECKLACE.get(), new SimpleCurioRenderer("panic_necklace", (BipedModel<LivingEntity>)NecklaceModel.panicNecklace()));
        renderers.put((Item)ModItems.SHOCK_PENDANT.get(), new SimpleCurioRenderer("pendant/shock_pendant", (BipedModel<LivingEntity>)NecklaceModel.pendant()));
        renderers.put((Item)ModItems.FLAME_PENDANT.get(), new SimpleCurioRenderer("pendant/flame_pendant", (BipedModel<LivingEntity>)NecklaceModel.pendant()));
        renderers.put((Item)ModItems.THORN_PENDANT.get(), new SimpleCurioRenderer("pendant/thorn_pendant", (BipedModel<LivingEntity>)NecklaceModel.pendant()));
        renderers.put((Item)ModItems.CHARM_OF_SINKING.get(), new SimpleCurioRenderer("charm_of_sinking", (BipedModel<LivingEntity>)NecklaceModel.charmOfSinking()));
        renderers.put((Item)ModItems.CLOUD_IN_A_BOTTLE.get(), new BeltCurioRenderer("cloud_in_a_bottle", BeltModel.cloudInABottle()));
        renderers.put((Item)ModItems.OBSIDIAN_SKULL.get(), new BeltCurioRenderer("obsidian_skull", BeltModel.obsidianSkull()));
        renderers.put((Item)ModItems.ANTIDOTE_VESSEL.get(), new BeltCurioRenderer("antidote_vessel", BeltModel.antidoteVessel()));
        renderers.put((Item)ModItems.UNIVERSAL_ATTRACTOR.get(), new BeltCurioRenderer("universal_attractor", BeltModel.universalAttractor()));
        renderers.put((Item)ModItems.CRYSTAL_HEART.get(), new BeltCurioRenderer("crystal_heart", BeltModel.crystalHeart()));
        renderers.put((Item)ModItems.HELIUM_FLAMINGO.get(), new SimpleCurioRenderer("helium_flamingo", BeltModel.heliumFlamingo()));
        renderers.put((Item)ModItems.DIGGING_CLAWS.get(), new GloveCurioRenderer("claws/digging_claws", "claws/digging_claws", HandsModel::claws));
        renderers.put((Item)ModItems.FERAL_CLAWS.get(), new GloveCurioRenderer("claws/feral_claws", "claws/feral_claws", HandsModel::claws));
        renderers.put((Item)ModItems.POWER_GLOVE.get(), new GloveCurioRenderer("power_glove"));
        renderers.put((Item)ModItems.FIRE_GAUNTLET.get(), new GlowingGloveCurioRenderer("fire_gauntlet"));
        renderers.put((Item)ModItems.POCKET_PISTON.get(), new GloveCurioRenderer("pocket_piston"));
        renderers.put((Item)ModItems.VAMPIRIC_GLOVE.get(), new GloveCurioRenderer("vampiric_glove"));
        renderers.put((Item)ModItems.GOLDEN_HOOK.get(), new GloveCurioRenderer("golden_hook", HandsModel::goldenHook));
        renderers.put((Item)ModItems.AQUA_DASHERS.get(), new SimpleCurioRenderer("aqua_dashers", LegsModel.aquaDashers(1.25f)));
        renderers.put((Item)ModItems.BUNNY_HOPPERS.get(), new SimpleCurioRenderer("bunny_hoppers", LegsModel.bunnyHoppers()));
        renderers.put((Item)ModItems.KITTY_SLIPPERS.get(), new SimpleCurioRenderer("kitty_slippers", LegsModel.kittySlippers()));
        renderers.put((Item)ModItems.RUNNING_SHOES.get(), new SimpleCurioRenderer("running_shoes", LegsModel.shoes(0.5f)));
        renderers.put((Item)ModItems.STEADFAST_SPIKES.get(), new SimpleCurioRenderer("steadfast_spikes", LegsModel.steadfastSpikes()));
        renderers.put((Item)ModItems.FLIPPERS.get(), new SimpleCurioRenderer("flippers", LegsModel.flippers()));
        renderers.put((Item)ModItems.WHOOPEE_CUSHION.get(), new SimpleCurioRenderer("whoopee_cushion", HeadModel.whoopeeCushion()));
    }
}

