/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets;

import com.supermartijn642.simplemagnets.DemagnetizationCoilTile;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ItemSpawnHandler {
    private static final ItemSpawnHandler SERVER = new ItemSpawnHandler();
    private static final ItemSpawnHandler CLIENT = new ItemSpawnHandler();
    private final HashMap<RegistryKey<World>, List<WeakReference<DemagnetizationCoilTile>>> tiles = new HashMap();

    private static ItemSpawnHandler getInstance(World world) {
        return world.field_72995_K ? CLIENT : SERVER;
    }

    public static void add(DemagnetizationCoilTile tile) {
        if (tile == null || tile.func_145837_r() || !tile.func_145830_o()) {
            return;
        }
        ItemSpawnHandler handler = ItemSpawnHandler.getInstance(tile.func_145831_w());
        handler.tiles.putIfAbsent((RegistryKey<World>)tile.func_145831_w().func_234923_W_(), new LinkedList());
        handler.tiles.get(tile.func_145831_w().func_234923_W_()).add(new WeakReference<DemagnetizationCoilTile>(tile));
    }

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinWorldEvent e) {
        if (!(e.getEntity() instanceof ItemEntity)) {
            return;
        }
        ItemEntity item = (ItemEntity)e.getEntity();
        ItemSpawnHandler handler = ItemSpawnHandler.getInstance(e.getWorld());
        handler.tiles.putIfAbsent((RegistryKey<World>)e.getWorld().func_234923_W_(), new LinkedList());
        ArrayList<WeakReference<DemagnetizationCoilTile>> toRemove = new ArrayList<WeakReference<DemagnetizationCoilTile>>();
        List<WeakReference<DemagnetizationCoilTile>> list = handler.tiles.get(e.getWorld().func_234923_W_());
        for (WeakReference<DemagnetizationCoilTile> reference : list) {
            DemagnetizationCoilTile tile = (DemagnetizationCoilTile)((Object)reference.get());
            if (tile == null || tile.func_145837_r() || !tile.func_145830_o()) {
                toRemove.add(reference);
                continue;
            }
            if (!tile.getArea().func_72318_a(item.func_213303_ch()) || !tile.shouldEffectItem(item.func_92059_d())) continue;
            item.getPersistentData().func_74757_a("PreventRemoteMovement", true);
            item.getPersistentData().func_74757_a("AllowMachineRemoteMovement", true);
        }
        list.removeAll(toRemove);
    }
}

