/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.util.wrap;

import dev.latvian.mods.rhino.util.wrap.TypeWrapper;
import dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;

public class ArrayTypeWrapperFactory<T>
implements TypeWrapperFactory<T[]> {
    public final TypeWrapper<T> typeWrapper;
    public final Class<T> target;
    public final Class<T[]> arrayTarget;
    private final T[] emptyArray;

    public ArrayTypeWrapperFactory(TypeWrapper<T> tw, Class<T> t, Class<T[]> at) {
        this.typeWrapper = tw;
        this.target = t;
        this.arrayTarget = at;
        this.emptyArray = (Object[])Array.newInstance(this.target, 0);
    }

    @Override
    public T[] wrap(Object o) {
        if (o == null) {
            return this.emptyArray;
        }
        if (o instanceof Iterable) {
            int size;
            if (o instanceof Collection) {
                size = ((Collection)o).size();
            } else {
                size = 0;
                for (Object o1 : (Iterable)o) {
                    ++size;
                }
            }
            if (size == 0) {
                return this.emptyArray;
            }
            Object[] array = (Object[])Array.newInstance(this.target, size);
            int index = 0;
            for (Object o1 : (Iterable)o) {
                if (!this.typeWrapper.validator.test(o1)) continue;
                array[index] = this.typeWrapper.factory.wrap(o1);
                ++index;
            }
            return index == 0 ? this.emptyArray : (index == array.length ? array : Arrays.copyOf(array, index, this.arrayTarget));
        }
        if (o.getClass().isArray()) {
            int size = Array.getLength(o);
            if (size == 0) {
                return this.emptyArray;
            }
            Object[] array = (Object[])Array.newInstance(this.target, size);
            int index = 0;
            for (int i = 0; i < array.length; ++i) {
                Object o1 = Array.get(o, i);
                if (!this.typeWrapper.validator.test(o1)) continue;
                array[index] = this.typeWrapper.factory.wrap(o1);
                ++index;
            }
            return index == 0 ? this.emptyArray : (index == array.length ? array : Arrays.copyOf(array, index, this.arrayTarget));
        }
        if (this.typeWrapper.validator.test(o)) {
            Object[] array = (Object[])Array.newInstance(this.target, 1);
            array[0] = this.typeWrapper.factory.wrap(o);
            return array;
        }
        return this.emptyArray;
    }
}

