/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.util.unit;

import dev.latvian.mods.rhino.util.unit.CeilUnit;
import dev.latvian.mods.rhino.util.unit.FloorUnit;
import dev.latvian.mods.rhino.util.unit.Unit;

public class FixedUnit
extends Unit {
    public static final FixedUnit ZERO = new FixedUnit(0.0f);
    public static final FixedUnit ONE = new FixedUnit(1.0f);
    public static final FixedUnit NAN = new FixedUnit(Float.NaN);
    public static final FixedUnit POS_INFINITY = new FixedUnit(Float.POSITIVE_INFINITY);
    public static final FixedUnit NEG_INFINITY = new FixedUnit(Float.NEGATIVE_INFINITY);
    private final float value;

    public static FixedUnit of(float value) {
        if (Float.isNaN(value)) {
            return NAN;
        }
        if (value == 0.0f) {
            return ZERO;
        }
        if (value == 1.0f) {
            return ONE;
        }
        if (value == Float.POSITIVE_INFINITY) {
            return POS_INFINITY;
        }
        if (value == Float.NEGATIVE_INFINITY) {
            return NEG_INFINITY;
        }
        return new FixedUnit(value);
    }

    protected FixedUnit(float v) {
        this.value = v;
    }

    @Override
    public float get() {
        return this.value;
    }

    @Override
    public boolean isFixed() {
        return true;
    }

    @Override
    public void append(StringBuilder sb) {
        sb.append(this.get());
    }

    public Unit newValue(float v) {
        return this.get() == v ? this : FixedUnit.of(v);
    }

    @Override
    public Unit neg() {
        return this.get() == 0.0f ? this : FixedUnit.of(-this.get());
    }

    @Override
    public Unit add(Unit with) {
        return with.isFixed() ? this.newValue(this.get() + with.get()) : super.add(with);
    }

    @Override
    public Unit sub(Unit with) {
        return with.isFixed() ? this.newValue(this.get() - with.get()) : super.sub(with);
    }

    @Override
    public Unit mul(Unit with) {
        return with.isFixed() ? this.newValue(this.get() * with.get()) : super.mul(with);
    }

    @Override
    public Unit div(Unit with) {
        return with.isFixed() ? this.newValue(this.get() / with.get()) : super.div(with);
    }

    @Override
    public Unit mod(Unit with) {
        return with.isFixed() ? this.newValue(this.get() % with.get()) : super.mod(with);
    }

    @Override
    public Unit pow(Unit with) {
        return with.isFixed() ? this.newValue((float)Math.pow(this.get(), with.get())) : super.pow(with);
    }

    @Override
    public Unit min(Unit with) {
        return with.isFixed() ? this.newValue(Math.min(this.get(), with.get())) : super.min(with);
    }

    @Override
    public Unit max(Unit with) {
        return with.isFixed() ? this.newValue(Math.max(this.get(), with.get())) : super.max(with);
    }

    @Override
    public Unit shiftLeft(Unit with) {
        return with.isFixed() ? this.newValue((int)this.get() << (int)with.get()) : super.shiftLeft(with);
    }

    @Override
    public Unit shiftRight(Unit with) {
        return with.isFixed() ? this.newValue((int)this.get() >> (int)with.get()) : super.shiftRight(with);
    }

    @Override
    public Unit abs() {
        return this.newValue(Math.abs(this.get()));
    }

    @Override
    public Unit sin() {
        return this.newValue((float)Math.sin(this.get()));
    }

    @Override
    public Unit cos() {
        return this.newValue((float)Math.cos(this.get()));
    }

    @Override
    public Unit tan() {
        return this.newValue((float)Math.tan(this.get()));
    }

    @Override
    public Unit atan() {
        return this.newValue((float)Math.atan(this.get()));
    }

    @Override
    public Unit atan2(Unit with) {
        return with.isFixed() ? this.newValue((float)Math.atan2(this.get(), with.get())) : super.atan2(with);
    }

    @Override
    public Unit deg() {
        return this.newValue((float)Math.toDegrees(this.get()));
    }

    @Override
    public Unit rad() {
        return this.newValue((float)Math.toRadians(this.get()));
    }

    @Override
    public Unit log() {
        return this.newValue((float)Math.log(this.get()));
    }

    @Override
    public Unit log10() {
        return this.newValue((float)Math.log10(this.get()));
    }

    @Override
    public Unit log1p() {
        return this.newValue((float)Math.log1p(this.get()));
    }

    @Override
    public Unit sqrt() {
        return this.newValue((float)Math.sqrt(this.get()));
    }

    @Override
    public Unit sq() {
        return this.newValue(this.get() * this.get());
    }

    @Override
    public Unit floor() {
        return this.newValue(FloorUnit.floor(this.get()));
    }

    @Override
    public Unit ceil() {
        return this.newValue(CeilUnit.ceil(this.get()));
    }
}

