/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.util.Deletable;
import dev.latvian.mods.rhino.util.MapLike;

public class NativeJavaMapLike
extends NativeJavaObject {
    private final MapLike<Object, Object> map;

    public NativeJavaMapLike(Scriptable scope, Object map) {
        super(scope, map, map.getClass());
        assert (map instanceof MapLike);
        this.map = (MapLike)map;
    }

    @Override
    public String getClassName() {
        return "JavaMapLike";
    }

    @Override
    public boolean has(String name, Scriptable start) {
        if (this.map.containsKeyML(name)) {
            return true;
        }
        return super.has(name, start);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        if (this.map.containsKeyML(index)) {
            return true;
        }
        return super.has(index, start);
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (this.map.containsKeyML(name)) {
            Context cx = Context.getContext();
            Object obj = this.map.getML(name);
            return cx.getWrapFactory().wrap(cx, this, obj, obj.getClass());
        }
        return super.get(name, start);
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this.map.containsKeyML(index)) {
            Context cx = Context.getContext();
            Object obj = this.map.getML(index);
            return cx.getWrapFactory().wrap(cx, this, obj, obj.getClass());
        }
        return super.get(index, start);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        this.map.putML(name, Context.jsToJava(value, Object.class));
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        this.map.putML(index, Context.jsToJava(value, Object.class));
    }

    @Override
    public Object[] getIds() {
        Object[] k = this.map.keysML().toArray();
        for (int i = 0; i < k.length; ++i) {
            if (k[i] instanceof Integer) continue;
            k[i] = ScriptRuntime.toString(k[i]);
        }
        return k;
    }

    @Override
    public void delete(String name) {
        Object obj = this.map.getML(name);
        this.map.removeML(name);
        Deletable.deleteObject(obj);
    }

    @Override
    public void delete(int index) {
        Object obj = this.map.getML(index);
        this.map.removeML(index);
        Deletable.deleteObject(obj);
    }
}

