/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Kit;

public class Decompiler {
    private static final int FUNCTION_END = 171;
    private char[] sourceBuffer = new char[128];
    private int sourceTop;

    String getEncodedSource() {
        return this.sourceToString(0);
    }

    int getCurrentOffset() {
        return this.sourceTop;
    }

    int markFunctionStart(int functionType) {
        int savedOffset = this.getCurrentOffset();
        if (functionType != 4) {
            this.addToken(110);
            this.append((char)functionType);
        }
        return savedOffset;
    }

    int markFunctionEnd(int functionStart) {
        int offset = this.getCurrentOffset();
        this.append('\u00ab');
        return offset;
    }

    void addToken(int token) {
        if (0 > token || token > 170) {
            throw new IllegalArgumentException();
        }
        this.append((char)token);
    }

    void addEOL(int token) {
        if (0 > token || token > 170) {
            throw new IllegalArgumentException();
        }
        this.append((char)token);
        this.append('\u0001');
    }

    void addName(String str) {
        this.addToken(39);
        this.appendString(str);
    }

    void addString(String str) {
        this.addToken(41);
        this.appendString(str);
    }

    void addTemplateLiteral(String str) {
        this.addToken(168);
        this.appendString(str);
    }

    void addRegexp(String regexp, String flags) {
        this.addToken(48);
        this.appendString('/' + regexp + '/' + flags);
    }

    void addNumber(double n) {
        this.addToken(40);
        long lbits = (long)n;
        if ((double)lbits != n) {
            lbits = Double.doubleToLongBits(n);
            this.append('D');
            this.append((char)(lbits >> 48));
            this.append((char)(lbits >> 32));
            this.append((char)(lbits >> 16));
            this.append((char)lbits);
        } else {
            if (lbits < 0L) {
                Kit.codeBug();
            }
            if (lbits <= 65535L) {
                this.append('S');
                this.append((char)lbits);
            } else {
                this.append('J');
                this.append((char)(lbits >> 48));
                this.append((char)(lbits >> 32));
                this.append((char)(lbits >> 16));
                this.append((char)lbits);
            }
        }
    }

    private void appendString(String str) {
        int nextTop;
        int L = str.length();
        int lengthEncodingSize = 1;
        if (L >= 32768) {
            lengthEncodingSize = 2;
        }
        if ((nextTop = this.sourceTop + lengthEncodingSize + L) > this.sourceBuffer.length) {
            this.increaseSourceCapacity(nextTop);
        }
        if (L >= 32768) {
            this.sourceBuffer[this.sourceTop] = (char)(0x8000 | L >>> 16);
            ++this.sourceTop;
        }
        this.sourceBuffer[this.sourceTop] = (char)L;
        ++this.sourceTop;
        str.getChars(0, L, this.sourceBuffer, this.sourceTop);
        this.sourceTop = nextTop;
    }

    private void append(char c) {
        if (this.sourceTop == this.sourceBuffer.length) {
            this.increaseSourceCapacity(this.sourceTop + 1);
        }
        this.sourceBuffer[this.sourceTop] = c;
        ++this.sourceTop;
    }

    private void increaseSourceCapacity(int minimalCapacity) {
        int newCapacity;
        if (minimalCapacity <= this.sourceBuffer.length) {
            Kit.codeBug();
        }
        if ((newCapacity = this.sourceBuffer.length * 2) < minimalCapacity) {
            newCapacity = minimalCapacity;
        }
        char[] tmp = new char[newCapacity];
        System.arraycopy(this.sourceBuffer, 0, tmp, 0, this.sourceTop);
        this.sourceBuffer = tmp;
    }

    private String sourceToString(int offset) {
        if (offset < 0 || this.sourceTop < offset) {
            Kit.codeBug();
        }
        return new String(this.sourceBuffer, offset, this.sourceTop - offset);
    }
}

