/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.misc;

import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.PlayerConfigs;
import shetiphian.platforms.Configuration;
import shetiphian.platforms.Values;
import shetiphian.platforms.client.gui.GuiPlatformSelect;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class EventHandler {
    private static long debounce;

    @SubscribeEvent
    public void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        TileEntity te;
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        if (player == null || stack.func_190926_b()) {
            return;
        }
        World world = event.getWorld();
        BlockState state = world.func_180495_p(event.getPos());
        if (state.func_177230_c() instanceof BlockPlatformBase && (te = world.func_175625_s(event.getPos())) instanceof TileEntityPlatformBase) {
            TileEntityPlatformBase tile = (TileEntityPlatformBase)te;
            if (player.func_213453_ef() && (Integer)state.func_177229_b((Property)BlockPlatformBase.LEVEL) == 0 && stack.func_77973_b() instanceof BlockItem && ((Boolean)Configuration.DUST_COVERING.canManuallyAdd.get()).booleanValue() && tile.setLevelTexture(stack)) {
                Function.setBlock((IWorld)world, (BlockPos)event.getPos(), (BlockState)((BlockState)state.func_206870_a((Property)BlockPlatformBase.LEVEL, (Comparable)Integer.valueOf(3))), (boolean)true);
                tile.playLevelTextureSound(player, true);
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
                return;
            }
            if (stack.func_77973_b().getToolTypes(stack).contains(Values.WRENCH) && state.func_177230_c() instanceof BlockPlatformBase) {
                boolean changeType;
                EnumPlatformType platformType = ((BlockPlatformBase)state.func_177230_c()).getPlatformType();
                boolean bl = changeType = platformType != EnumPlatformType.FRAME && player.func_213453_ef();
                if (changeType && this.useGUI(player, platformType)) {
                    DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.openGUISelect(player, world, event.getPos(), platformType, tile));
                } else {
                    BlockState result = ((BlockPlatformBase)state.func_177230_c()).rotateBlock(state, (IWorld)world, event.getPos(), tile, changeType ? Rotation.NONE : Rotation.COUNTERCLOCKWISE_90);
                    player.func_184609_a(event.getHand());
                    if (!changeType && result != state) {
                        Function.setBlock((IWorld)world, (BlockPos)event.getPos(), (BlockState)result, (boolean)true);
                    }
                }
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
        }
    }

    private boolean useGUI(PlayerEntity player, EnumPlatformType platformType) {
        int option = player.field_70170_p.field_72995_K ? ((Configuration.Menu_General.PlatformSelect)((Object)Configuration.GENERAL.platformSelect.get())).ordinal() : ((Integer)PlayerConfigs.getConfig((PlayerEntity)player, (ResourceLocation)Values.keyConfigPlatformSelectMode, (Object)Configuration.Menu_General.PlatformSelect.MIXED.ordinal())).intValue();
        return option == Configuration.Menu_General.PlatformSelect.GUI.ordinal() || option == Configuration.Menu_General.PlatformSelect.MIXED.ordinal() && (platformType == EnumPlatformType.FLAT || platformType == EnumPlatformType.FLOOR);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openGUISelect(PlayerEntity player, World world, BlockPos pos, EnumPlatformType platformType, TileEntityPlatformBase tile) {
        if (System.currentTimeMillis() > debounce + 250L) {
            debounce = System.currentTimeMillis();
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiPlatformSelect(player, world, pos, platformType, tile));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && event.getEntity() instanceof PlayerEntity) {
            Configuration.sync();
        }
    }
}

