/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoader;
import shetiphian.core.client.model.RetexturedBlockModel;
import shetiphian.platforms.Platforms;
import shetiphian.platforms.client.model.ModelData;
import shetiphian.platforms.client.model.Parts;

@OnlyIn(value=Dist.CLIENT)
public class CacheBuilder {
    static Table<String, String, EnumMap<Direction, IBakedModel>> CACHE = HashBasedTable.create();
    private static final List<String> PART_ERROR = new ArrayList<String>();
    private static ModelBakery bakery;
    private static Function<RenderMaterial, TextureAtlasSprite> spriteGetter;
    private static ItemModelMesher mesher;

    static void setup(ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter) {
        CacheBuilder.bakery = bakery;
        CacheBuilder.spriteGetter = spriteGetter;
    }

    static void rebuildCache() {
        CACHE.clear();
    }

    public static IBakedModel get(String part, String key, Direction facing, String particle) {
        Map map;
        if (!CACHE.contains((Object)part, (Object)key)) {
            CacheBuilder.buildCache(part, key, particle);
        }
        if ((map = (Map)CACHE.get((Object)part, (Object)key)) == null) {
            map = (Map)CACHE.get((Object)part, (Object)"default");
        }
        return map == null ? null : (IBakedModel)map.get(facing);
    }

    static void buildCache(String part, String key, String particle) {
        IUnbakedModel unbaked;
        ModelData modeldata = null;
        for (ModelData data : Parts.MODELS) {
            if (!data.getName().equalsIgnoreCase(part)) continue;
            modeldata = data;
            break;
        }
        if (modeldata == null) {
            return;
        }
        try {
            unbaked = ModelLoader.instance().getModelOrMissing(modeldata.getLocation());
        }
        catch (Exception ignored) {
            String partName = part.toLowerCase(Locale.ROOT);
            if (!PART_ERROR.contains(partName)) {
                Platforms.LOGGER.error("Unable to retrieve model form the ModelLoaderRegistry, this part may not render correctly: " + part);
                PART_ERROR.add(partName);
            }
            return;
        }
        if (!CACHE.contains((Object)modeldata.getName(), (Object)"default")) {
            if (unbaked instanceof BlockModel) {
                CACHE.put((Object)modeldata.getName(), (Object)"default", CacheBuilder.getMap((IUnbakedModel)RetexturedBlockModel.from((BlockModel)((BlockModel)unbaked)).retexture(CacheBuilder.setTextures(modeldata, modeldata.getDefaultTexture(), particle)), modeldata.getLocation()));
            } else {
                CACHE.put((Object)modeldata.getName(), (Object)"default", CacheBuilder.getMap(unbaked, modeldata.getLocation()));
            }
        }
        if (!key.equals("default")) {
            if (unbaked instanceof BlockModel) {
                CACHE.put((Object)modeldata.getName(), (Object)key, CacheBuilder.getMap((IUnbakedModel)RetexturedBlockModel.from((BlockModel)((BlockModel)unbaked)).retexture(CacheBuilder.setTextures(modeldata, key, particle)), modeldata.getLocation()));
            } else {
                CACHE.put((Object)modeldata.getName(), (Object)key, CacheBuilder.getMap(unbaked, modeldata.getLocation()));
            }
        }
    }

    static String getTexture(ItemStack stack) {
        return CacheBuilder.getTextureSprite(stack).func_195668_m().toString();
    }

    static TextureAtlasSprite getTextureSprite(ItemStack stack) {
        try {
            if (mesher == null) {
                mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
            }
            IBakedModel model = mesher.func_178089_a(stack);
            return model.func_177554_e();
        }
        catch (Exception exception) {
            return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(MissingTextureSprite.func_195675_b());
        }
    }

    private static ImmutableMap<String, String> setTextures(ModelData modeldata, String texture, String particle) {
        if (modeldata.getName().contains("brazier_base")) {
            return new ImmutableMap.Builder().put((Object)"brazier", (Object)texture).put((Object)"particle", (Object)particle).build();
        }
        if (modeldata.getName().contains("brazier_fill")) {
            return new ImmutableMap.Builder().put((Object)"fill", (Object)texture).put((Object)"particle", (Object)particle).build();
        }
        return new ImmutableMap.Builder().put((Object)"texture", (Object)texture).put((Object)"particle", (Object)particle).build();
    }

    private static EnumMap<Direction, IBakedModel> getMap(IUnbakedModel model, ResourceLocation location) {
        EnumMap<Direction, IBakedModel> map = new EnumMap<Direction, IBakedModel>(Direction.class);
        map.put(Direction.NORTH, model.func_225613_a_(bakery, spriteGetter, (IModelTransform)ModelRotation.X0_Y0, location));
        map.put(Direction.EAST, model.func_225613_a_(bakery, spriteGetter, (IModelTransform)ModelRotation.X0_Y90, location));
        map.put(Direction.SOUTH, model.func_225613_a_(bakery, spriteGetter, (IModelTransform)ModelRotation.X0_Y180, location));
        map.put(Direction.WEST, model.func_225613_a_(bakery, spriteGetter, (IModelTransform)ModelRotation.X0_Y270, location));
        return map;
    }
}

