/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.enviroenergy.m_thermal.tile;

import com.google.common.collect.Lists;
import com.valkyrieofnight.envirocore.core.energy.UniPotentialBattery;
import com.valkyrieofnight.envirocore.core.tile.ccu.PassivePotEnergyCCUTile;
import com.valkyrieofnight.envirocore.multiblock.io.IForgeEnergyIO;
import com.valkyrieofnight.enviroenergy.m_thermal.EThermal;
import com.valkyrieofnight.enviroenergy.m_thermal.IThermalCellTile;
import com.valkyrieofnight.enviroenergy.m_thermal.datapack.blockheat.BlockTemp;
import com.valkyrieofnight.enviroenergy.m_thermal.datapack.fluidheat.FluidTemp;
import com.valkyrieofnight.enviroenergy.m_thermal.ui.ThermalGenContainer;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.IFacing;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.math.RelativeDirection;
import com.valkyrieofnight.vlib.core.util.math.XYZOrientation;
import com.valkyrieofnight.vlib.core.util.obj.IOMode;
import com.valkyrieofnight.vlib.multiblock.StructureMap;
import com.valkyrieofnight.vlib.multiblock.ui.container.ControllerContainer;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public abstract class ThermalCCUTile
extends PassivePotEnergyCCUTile<ControllerContainer<ThermalCCUTile>>
implements IForgeEnergyIO,
IFacing {
    protected CellScanner thermalScanner;
    private int totalHeat;
    private int totalCold;
    private int totalDelta;
    private int totalValid = 0;
    private long potentialTick = 0L;
    private float totalCellEfficiency = 0.0f;

    public ControllerContainer<ThermalCCUTile> createContainer(int i, PlayerEntity playerEntity, TileEntity tileEntity) {
        return new ThermalGenContainer(i, playerEntity.field_71071_by, (ThermalCCUTile)tileEntity);
    }

    public ThermalCCUTile(TileEntityType<?> tileEntityTypeIn, UniPotentialBattery battery) {
        super(tileEntityTypeIn, battery);
    }

    public List<XYZOrientation> getValid() {
        return XYZOrientation.getAllWith((Direction)this.direction, (RelativeDirection)RelativeDirection.FORWARD);
    }

    public void queueValidOrientations(Queue<XYZOrientation> orientationQueue) {
        orientationQueue.addAll(this.getValid());
    }

    protected void serverTickFormed() {
        super.serverTickFormed();
        if (this.thermalScanner != null) {
            this.thermalScanner.tick();
        }
    }

    protected void onMultiblockFormed() {
        super.onMultiblockFormed();
        if (this.thermalScanner == null) {
            this.thermalScanner = new CellScanner(this, 3);
        }
    }

    private long getPotentialForTick() {
        return this.potentialTick;
    }

    protected void onProcessTick(int i) {
        this.battery.receiveInternal(this.potentialTick * (long)i, false);
    }

    public StructureMap getStructureList() {
        return EThermal.getStructureList();
    }

    @NotNull
    public IOMode getFEIOMode() {
        return IOMode.OUT;
    }

    public void setFacing(Direction direction) {
        this.direction = direction;
    }

    protected Collection<BlockPos> getAllThermalCells() {
        return this.getStructure().getLayoutList(EThermal.CELL).getAllRotated(this.field_174879_c, this.getOrientation());
    }

    protected void finishedQueue() {
        this.potentialTick = (long)((float)this.totalDelta * this.getArrayEfficiency() * (this.totalCellEfficiency / (float)this.totalValid));
    }

    protected abstract float getArrayEfficiency();

    protected static class CellScanner {
        private ThermalCCUTile tile;
        private Queue<BlockPos> queue = Lists.newLinkedList();
        private World world;
        private int scanRate;
        private int totalValid;
        private int totalHeat;
        private int totalCold;
        private int totalDelta;
        private float totalEfficiency;

        public CellScanner(ThermalCCUTile tile, int scanRate) {
            this.tile = tile;
            this.scanRate = scanRate;
            this.world = tile.func_145831_w();
        }

        public void tick() {
            for (int i = 0; i < this.scanRate; ++i) {
                if (!this.checkThermals()) continue;
                ++this.totalValid;
            }
        }

        protected boolean checkThermals() {
            boolean registry = false;
            if (this.queue.isEmpty()) {
                this.startQueue();
                return false;
            }
            BlockPos pos = this.queue.poll();
            TileEntity te = this.world.func_175625_s(pos);
            XYZOrientation orientation = this.tile.getOrientation();
            Direction down = orientation.getDirectionFrom(RelativeDirection.DOWN);
            Direction up = orientation.getDirectionFrom(RelativeDirection.UP);
            int downHeat = Fluids.field_204546_a.getAttributes().getTemperature();
            int upHeat = Fluids.field_204546_a.getAttributes().getTemperature();
            FluidState df = this.world.func_204610_c(pos.func_177972_a(down));
            if (df.func_206886_c() != Fluids.field_204541_a) {
                FluidTemp ft = EThermal.FT_REGISTRY.getFluidTemp(this.tile.conditionContainerProvider, new FluidStack(df.func_206886_c(), 1000));
                downHeat = ft != null ? ft.getTemp() : (df.func_206889_d() ? df.func_206886_c().getAttributes().getTemperature() : downHeat);
            } else {
                BlockState bs = this.world.func_180495_p(pos);
                BlockTemp bt = EThermal.BT_REGISTRY.getTemp(this.tile.conditionContainerProvider, bs.func_177230_c());
                if (bt != null) {
                    upHeat = bt.getTemp();
                }
            }
            FluidState uf = this.world.func_204610_c(pos.func_177972_a(up));
            if (uf.func_206886_c() != Fluids.field_204541_a) {
                FluidTemp ft = EThermal.FT_REGISTRY.getFluidTemp(this.tile.conditionContainerProvider, new FluidStack(df.func_206886_c(), 1000));
                upHeat = ft != null ? ft.getTemp() : (uf.func_206889_d() ? uf.func_206886_c().getAttributes().getTemperature() : upHeat);
            } else {
                BlockState bs = this.world.func_180495_p(pos);
                BlockTemp bt = EThermal.BT_REGISTRY.getTemp(this.tile.conditionContainerProvider, bs.func_177230_c());
                if (bt != null) {
                    upHeat = bt.getTemp();
                }
            }
            int cold = Math.min(downHeat, upHeat);
            int heat = Math.max(downHeat, upHeat);
            if (heat != cold) {
                this.totalHeat += heat;
                this.totalCold += cold;
                this.totalDelta += heat - cold;
                if (te instanceof IThermalCellTile) {
                    this.totalEfficiency += ((IThermalCellTile)te).getEfficiencyMultiplier();
                }
                return true;
            }
            return false;
        }

        protected void startQueue() {
            this.tile.totalCold = this.totalCold;
            this.tile.totalHeat = this.totalHeat;
            this.tile.totalDelta = this.totalDelta;
            this.tile.totalValid = this.totalValid;
            this.tile.totalCellEfficiency = this.totalEfficiency;
            this.tile.finishedQueue();
            this.totalHeat = 0;
            this.totalCold = 0;
            this.totalValid = 0;
            this.totalDelta = 0;
            this.totalEfficiency = 0.0f;
            this.queue.clear();
            this.queue.addAll(this.tile.getAllThermalCells());
        }
    }
}

