/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.enviroenergy.m_lightning.tile;

import com.valkyrieofnight.envirocore.core.energy.UniPotentialBattery;
import com.valkyrieofnight.envirocore.core.tile.ccu.PassivePotEnergyCCUTile;
import com.valkyrieofnight.envirocore.m_comp.m_modifier.CModifiersModule;
import com.valkyrieofnight.envirocore.multiblock.io.IForgeEnergyIO;
import com.valkyrieofnight.enviroenergy.m_lightning.EELightning;
import com.valkyrieofnight.enviroenergy.m_lightning.ui.LightningCCUContainer;
import com.valkyrieofnight.enviroenergyapi.util.EnergyUtil;
import com.valkyrieofnight.vlib.core.util.WorldUtils;
import com.valkyrieofnight.vlib.core.util.math.BlockPosUtil;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import com.valkyrieofnight.vlib.core.util.math.RelativeDirection;
import com.valkyrieofnight.vlib.core.util.math.XYZOrientation;
import com.valkyrieofnight.vlib.modifier.AbstractModifierHandler;
import com.valkyrieofnight.vlib.multiblock.StructureMap;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class LightningCCUTile
extends PassivePotEnergyCCUTile<LightningCCUContainer>
implements IForgeEnergyIO {
    public static int PRODUCTION_RATE = 750000;
    public static double PRODUCTION_POWER = 3.0;
    public static int PRODUCTION_RADIANT = 70;
    public static int THUNDER_DURATION_MAX = 800;
    private Random random = new Random();
    private int thisDuration = 0;
    private final long maxPotentialPulse;
    private BlockPos rodTop;
    private float baseStatic = 0.5f;

    public LightningCCUContainer createContainer(int i, PlayerEntity playerEntity, TileEntity tileEntity) {
        return new LightningCCUContainer(i, playerEntity.field_71071_by, this);
    }

    public static int getThunderDurationMin(int max) {
        return max / 2;
    }

    public static int getOtherDurationMax() {
        return THUNDER_DURATION_MAX * 4;
    }

    public static int getOtherDurationMin() {
        return LightningCCUTile.getThunderDurationMin(LightningCCUTile.getOtherDurationMax());
    }

    public static long getMultiplier(int tier) {
        if (tier <= 0) {
            return 1L;
        }
        return (long)Math.pow(PRODUCTION_POWER, tier - 1);
    }

    public static long getRodGen(int tier) {
        return EnergyUtil.FE_CONVERTER.convertToPotential((Number)PRODUCTION_RATE) * LightningCCUTile.getMultiplier(tier);
    }

    public static long getMinPotentailPulse(long max) {
        return max / 8L;
    }

    public static long getPotentialRadiant(int tier) {
        return (long)((double)EnergyUtil.FE_CONVERTER.convertToPotential((Number)PRODUCTION_RADIANT) * ((double)tier * ((double)tier * 0.25) + 0.75));
    }

    public static long getPotentialElectrostatic(int tier) {
        return LightningCCUTile.getRodGen(tier) / 1000L;
    }

    public LightningCCUTile(TileEntityType<?> tileEntityTypeIn, UniPotentialBattery battery, long maxPotentialPulse) {
        super(tileEntityTypeIn, battery);
        this.setDirection(Direction.UP);
        this.maxPotentialPulse = maxPotentialPulse;
        this.modifierHandler.addScannable(CModifiersModule.ELECTROSTATIC_ATTRIBUTE.getID());
        this.modifierHandler.addScannable(CModifiersModule.RADIANT_ATTRIBUTE.getID());
    }

    public List<XYZOrientation> getValid() {
        return XYZOrientation.getAllWith((Direction)Direction.UP, (RelativeDirection)RelativeDirection.FORWARD);
    }

    public void queueValidOrientations(Queue<XYZOrientation> orientationQueue) {
        orientationQueue.addAll(this.getValid());
    }

    protected void onMultiblockFormed() {
        super.onMultiblockFormed();
        this.acquireRodTop();
    }

    protected void onMultiblockDeform() {
        super.onMultiblockDeform();
    }

    protected void onProcessStart() {
        this.thisDuration = this.func_145831_w().func_72911_I() ? MathUtil.getRandomRange((Random)this.random, (int)LightningCCUTile.getThunderDurationMin(this.getThunderDurationMax()), (int)this.getThunderDurationMax()) : MathUtil.getRandomRange((Random)this.random, (int)LightningCCUTile.getThunderDurationMin(this.getNormalDurationMax()), (int)this.getNormalDurationMax());
    }

    protected void onProcessTick(int i) {
        this.battery.receiveInternal(this.getPotentialPassive(i), false);
    }

    private long getPotentialPassive(int i) {
        if (this.field_145850_b.func_82737_E() % 30L == 0L) {
            this.baseStatic = this.random.nextFloat();
        }
        if (this.field_145850_b.func_72911_I() && this.tracker.getCurrentDuration() > this.getThunderDurationMax()) {
            this.tracker.reset();
        }
        int tier = this.getTier().getTier();
        long potEnergy = 0L;
        if (!this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I()) {
            double mult = CModifiersModule.RADIANT_ATTRIBUTE.getModifiedValue((AbstractModifierHandler)this.modifierHandler, Float.valueOf(0.0f)).floatValue();
            long radEnergy = (long)((double)((float)LightningCCUTile.getPotentialRadiant(tier) * (WorldUtils.getSunBrightness((World)this.field_145850_b, (float)1.0f) + 0.1f)) * mult);
            potEnergy += radEnergy * (long)i;
        }
        double strength = 1.0 + (double)this.baseStatic + (double)this.field_145850_b.func_72867_j(1.0f) + (double)this.field_145850_b.func_72819_i(1.0f);
        double mult = (double)(CModifiersModule.ELECTROSTATIC_ATTRIBUTE.getModifiedValue((AbstractModifierHandler)this.modifierHandler, Float.valueOf(0.0f)).floatValue() / 40.0f) * strength;
        long statEnergy = (long)((double)LightningCCUTile.getPotentialElectrostatic(tier) * mult);
        return potEnergy += statEnergy;
    }

    protected void onProcessComplete() {
        Random rand = new Random();
        if (rand.nextInt(100) < this.getChance()) {
            BlockPos top = this.rodTop;
            if (top != null) {
                LightningBoltEntity lbe = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.field_145850_b);
                lbe.func_70107_b((double)top.func_177958_n() + 0.5, (double)top.func_177956_o() + 0.5, (double)top.func_177952_p() + 0.5);
                lbe.func_213312_b((double)top.func_177958_n() + 0.5, (double)top.func_177956_o() + 0.5, (double)top.func_177952_p() + 0.5);
                this.field_145850_b.func_217376_c((Entity)lbe);
            } else {
                this.acquireRodTop();
            }
            int rfMin = (Integer)EnergyUtil.FE_CONVERTER.convertFromPotential(LightningCCUTile.getMinPotentailPulse(this.maxPotentialPulse));
            int rfMax = (Integer)EnergyUtil.FE_CONVERTER.convertFromPotential(this.maxPotentialPulse);
            int rfRand = MathUtil.getRandomRange((Random)rand, (int)rfMin, (int)rfMax);
            this.battery.receiveInternal(EnergyUtil.FE_CONVERTER.convertToPotential((Number)rfRand), false);
        }
    }

    public StructureMap getStructureList() {
        return EELightning.SL;
    }

    private void acquireRodTop() {
        Collection positions = this.scanner.getAllOfType(EELightning.LIGHTNING_ROD);
        int furthest = 0;
        for (BlockPos pos : positions) {
            int dist = Math.abs(BlockPosUtil.getDirectionDistance((BlockPos)this.field_174879_c, (BlockPos)pos, (Direction)this.getOrientation().getDirectionFrom(RelativeDirection.FORWARD)));
            if (dist <= furthest) continue;
            furthest = dist;
            this.rodTop = pos;
        }
    }

    protected int getProcessDuration() {
        return this.thisDuration;
    }

    public int getThunderDurationMax() {
        return 300;
    }

    private int getChance() {
        int max = this.getMaxChance();
        int chanceReduction = (int)(15.0f * CModifiersModule.ELECTROSTATIC_ATTRIBUTE.getModifiedValue((AbstractModifierHandler)this.modifierHandler, Float.valueOf(0.0f)).floatValue());
        return Math.max(5, max - chanceReduction);
    }

    public abstract int getMaxChance();

    public int getNormalDurationMax() {
        return this.getThunderDurationMax() * 4;
    }
}

